/*
 * Decompiled with CFR 0.152.
 */
package core.utils;

import core.ParallelSubpopulations;
import core.Subpopulation;
import core.utils.NotAValidCompositionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Common {
    public static double rESOLUTION = 0.01;
    public static int MAX_PM = 6;
    public static Set<Double> allowed_SP_FREQUENCIES;
    private static Set<Double> allowed_SP_CNV_FREQUENCIES;
    private static Map<Double, Set<Double>> allowedSiblings_SP_FREQUENCIES;

    static {
        allowed_SP_CNV_FREQUENCIES = null;
        allowedSiblings_SP_FREQUENCIES = null;
        allowed_SP_FREQUENCIES = Common.seq(0.0, 0.99, rESOLUTION);
    }

    public static Set<Double> seq(double min, double max, double step) {
        HashSet<Double> d = new HashSet<Double>();
        double v = min - step;
        while (v < max) {
            d.add(v += step);
        }
        return d;
    }

    public static <C> List<C> toList(C[] value) {
        ArrayList<C> l = new ArrayList<C>();
        C[] CArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            C d = CArray[n2];
            l.add(d);
            ++n2;
        }
        return l;
    }

    public static void setALLOWED_SP_FREQUENCIES(double[] aLLOWED_FREQUENCIES) {
        allowed_SP_FREQUENCIES = new HashSet<Double>();
        int i = 0;
        while (i < aLLOWED_FREQUENCIES.length) {
            allowed_SP_FREQUENCIES.add(aLLOWED_FREQUENCIES[i]);
            ++i;
        }
        allowedSiblings_SP_FREQUENCIES = null;
        allowed_SP_CNV_FREQUENCIES = null;
    }

    public static void setALLOWED_SP_CNV_FREQUENCIES(double[] aLLOWED_FREQUENCIES) {
        allowed_SP_CNV_FREQUENCIES = new HashSet<Double>();
        int i = 0;
        while (i < aLLOWED_FREQUENCIES.length) {
            allowed_SP_CNV_FREQUENCIES.add(aLLOWED_FREQUENCIES[i]);
            ++i;
        }
    }

    public static void setAllowedSiblings_SP_FREQUENCIES(double sp, double sibling) {
        if (allowedSiblings_SP_FREQUENCIES == null) {
            allowedSiblings_SP_FREQUENCIES = new HashMap<Double, Set<Double>>();
        }
        if (!allowedSiblings_SP_FREQUENCIES.containsKey(sp)) {
            allowedSiblings_SP_FREQUENCIES.put(sp, new HashSet());
        }
        allowedSiblings_SP_FREQUENCIES.get(sp).add(sibling);
    }

    public static void setAllowedSiblings_SP_FREQUENCIES() {
        if (allowedSiblings_SP_FREQUENCIES == null) {
            allowedSiblings_SP_FREQUENCIES = new HashMap<Double, Set<Double>>();
        }
    }

    public static Set<Double> getallowed_SP_FREQUENCIES() {
        return allowed_SP_FREQUENCIES;
    }

    public static Set<Double> getAllowed_SP_CNV_FREQUENCIES() {
        if (allowed_SP_CNV_FREQUENCIES == null || allowed_SP_CNV_FREQUENCIES.size() == 0) {
            return allowed_SP_FREQUENCIES;
        }
        return allowed_SP_CNV_FREQUENCIES;
    }

    public static Set<Double> getAllowedSiblings_SP_FREQUENCIES(Double sp) {
        if (allowedSiblings_SP_FREQUENCIES == null) {
            return allowed_SP_FREQUENCIES;
        }
        if (!allowedSiblings_SP_FREQUENCIES.containsKey(sp)) {
            return new HashSet<Double>();
        }
        return allowedSiblings_SP_FREQUENCIES.get(sp);
    }

    public static Set<Double> getAllowedPaternal_SP_FREQUENCIES(Double sp) {
        if (allowedSiblings_SP_FREQUENCIES == null) {
            return allowed_SP_FREQUENCIES;
        }
        HashSet<Double> v = new HashSet<Double>();
        v.addAll(allowed_SP_FREQUENCIES);
        v.removeAll(Common.getAllowedSiblings_SP_FREQUENCIES(sp));
        return v;
    }

    public static void setMAX_PM(int max_PM) {
        MAX_PM = max_PM;
    }

    public static Double[] below(double f, Set<Double> a) {
        ArrayList<Double> l = new ArrayList<Double>();
        for (Double d : a) {
            if (!(d <= f)) continue;
            l.add(d);
        }
        return l.toArray(new Double[l.size()]);
    }

    public static Double[] above(double f, Set<Double> a) {
        ArrayList<Double> l = new ArrayList<Double>();
        for (Double d : a) {
            if (!(d >= f)) continue;
            l.add(d);
        }
        return l.toArray(new Double[l.size()]);
    }

    public static void main(String[] args) {
        try {
            Common.setMAX_PM(6);
            Common.setALLOWED_SP_FREQUENCIES(new double[]{0.335, 0.455, 0.515, 0.65, 0.725, 0.995});
            Common.setAllowedSiblings_SP_FREQUENCIES();
            ParallelSubpopulations sps = new ParallelSubpopulations(2.999514, 0.088, 0, false, 3);
            Map<Double, Double> d = sps.getCellFreq2ProbabilityMap();
            Map<Subpopulation, Double> ds = sps.getSubpopulation2ProbabilityMap();
            Map.Entry<Subpopulation, Double> sp = sps.getBestFittingSubpopulation();
            System.out.println(sp);
            if (sp.getKey().getChild() != null) {
                System.out.println("Child--> " + sp.getKey().getChild());
            } else {
                System.out.println("Parent--> " + sp.getKey().getParent());
            }
        }
        catch (NotAValidCompositionException e) {
            e.printStackTrace();
        }
    }
}

