/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.util.ExceptionContext;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.IllConditionedOperatorException;
import org.apache.commons.math3.linear.IterativeLinearSolverEvent;
import org.apache.commons.math3.linear.NonPositiveDefiniteOperatorException;
import org.apache.commons.math3.linear.NonSelfAdjointOperatorException;
import org.apache.commons.math3.linear.NonSquareOperatorException;
import org.apache.commons.math3.linear.PreconditionedIterativeLinearSolver;
import org.apache.commons.math3.linear.RealLinearOperator;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularOperatorException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.IterationManager;
import org.apache.commons.math3.util.MathUtils;

public class SymmLQ
extends PreconditionedIterativeLinearSolver {
    private static final double CBRT_MACH_PREC;
    private static final double MACH_PREC;
    private static final String OPERATOR = "operator";
    private static final String THRESHOLD = "threshold";
    private static final String VECTOR = "vector";
    private static final String VECTOR1 = "vector1";
    private static final String VECTOR2 = "vector2";
    private final boolean check;
    private final double delta;

    public SymmLQ(int maxIterations, double delta, boolean check) {
        super(maxIterations);
        this.delta = delta;
        this.check = check;
    }

    public SymmLQ(IterationManager manager, double delta, boolean check) {
        super(manager);
        this.delta = delta;
        this.check = check;
    }

    private static void checkSymmetry(RealLinearOperator l, RealVector x, RealVector y, RealVector z) throws NonSelfAdjointOperatorException {
        double s = y.dotProduct(y);
        double t = x.dotProduct(z);
        double epsa = (s + MACH_PREC) * CBRT_MACH_PREC;
        if (FastMath.abs(s - t) > epsa) {
            NonSelfAdjointOperatorException e = new NonSelfAdjointOperatorException();
            ExceptionContext context = e.getContext();
            context.setValue(OPERATOR, l);
            context.setValue(VECTOR1, x);
            context.setValue(VECTOR2, y);
            context.setValue(THRESHOLD, epsa);
            throw e;
        }
    }

    private static void daxpbypz(double a, RealVector x, double b, RealVector y, RealVector z) {
        int n = z.getDimension();
        for (int i = 0; i < n; ++i) {
            double zi = a * x.getEntry(i) + b * y.getEntry(i) + z.getEntry(i);
            z.setEntry(i, zi);
        }
    }

    private static void daxpy(double a, RealVector x, RealVector y) {
        int n = x.getDimension();
        for (int i = 0; i < n; ++i) {
            y.setEntry(i, a * x.getEntry(i) + y.getEntry(i));
        }
    }

    private static void throwNPDLOException(RealLinearOperator l, RealVector v) throws NonPositiveDefiniteOperatorException {
        NonPositiveDefiniteOperatorException e = new NonPositiveDefiniteOperatorException();
        ExceptionContext context = e.getContext();
        context.setValue(OPERATOR, l);
        context.setValue(VECTOR, v);
        throw e;
    }

    public final boolean getCheck() {
        return this.check;
    }

    public RealVector solve(RealLinearOperator a, RealLinearOperator minv, RealVector b) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, MaxCountExceededException, NonSelfAdjointOperatorException, NonPositiveDefiniteOperatorException, IllConditionedOperatorException {
        MathUtils.checkNotNull(a);
        ArrayRealVector x = new ArrayRealVector(a.getColumnDimension());
        return this.solveInPlace(a, minv, b, x, false, 0.0);
    }

    public RealVector solve(RealLinearOperator a, RealLinearOperator minv, RealVector b, boolean goodb, double shift) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, MaxCountExceededException, NonSelfAdjointOperatorException, NonPositiveDefiniteOperatorException, IllConditionedOperatorException {
        MathUtils.checkNotNull(a);
        ArrayRealVector x = new ArrayRealVector(a.getColumnDimension());
        return this.solveInPlace(a, minv, b, x, goodb, shift);
    }

    public RealVector solve(RealLinearOperator a, RealLinearOperator minv, RealVector b, RealVector x) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, NonSelfAdjointOperatorException, NonPositiveDefiniteOperatorException, IllConditionedOperatorException, MaxCountExceededException {
        MathUtils.checkNotNull(x);
        return this.solveInPlace(a, minv, b, x.copy(), false, 0.0);
    }

    public RealVector solve(RealLinearOperator a, RealVector b) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, NonSelfAdjointOperatorException, IllConditionedOperatorException, MaxCountExceededException {
        MathUtils.checkNotNull(a);
        ArrayRealVector x = new ArrayRealVector(a.getColumnDimension());
        ((RealVector)x).set(0.0);
        return this.solveInPlace(a, null, b, x, false, 0.0);
    }

    public RealVector solve(RealLinearOperator a, RealVector b, boolean goodb, double shift) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, NonSelfAdjointOperatorException, IllConditionedOperatorException, MaxCountExceededException {
        MathUtils.checkNotNull(a);
        ArrayRealVector x = new ArrayRealVector(a.getColumnDimension());
        return this.solveInPlace(a, null, b, x, goodb, shift);
    }

    public RealVector solve(RealLinearOperator a, RealVector b, RealVector x) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, NonSelfAdjointOperatorException, IllConditionedOperatorException, MaxCountExceededException {
        MathUtils.checkNotNull(x);
        return this.solveInPlace(a, null, b, x.copy(), false, 0.0);
    }

    public RealVector solveInPlace(RealLinearOperator a, RealLinearOperator minv, RealVector b, RealVector x) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, NonSelfAdjointOperatorException, NonPositiveDefiniteOperatorException, IllConditionedOperatorException, MaxCountExceededException {
        return this.solveInPlace(a, minv, b, x, false, 0.0);
    }

    public RealVector solveInPlace(RealLinearOperator a, RealLinearOperator minv, RealVector b, RealVector x, boolean goodb, double shift) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, NonSelfAdjointOperatorException, NonPositiveDefiniteOperatorException, IllConditionedOperatorException, MaxCountExceededException {
        SymmLQ.checkParameters(a, minv, b, x);
        IterationManager manager = this.getIterationManager();
        manager.resetIterationCount();
        manager.incrementIterationCount();
        State state = new State(a, minv, b, x, goodb, shift);
        SymmLQEvent event = new SymmLQEvent(this, state);
        if (state.beta1 == 0.0) {
            manager.fireTerminationEvent(event);
            return x;
        }
        boolean earlyStop = state.beta < MACH_PREC || state.hasConverged;
        manager.fireInitializationEvent(event);
        if (!earlyStop) {
            do {
                manager.incrementIterationCount();
                manager.fireIterationStartedEvent(event);
                state.update();
                manager.fireIterationPerformedEvent(event);
            } while (!state.hasConverged);
        }
        state.refine(x);
        state.bstep = 0.0;
        state.gammaZeta = 0.0;
        manager.fireTerminationEvent(event);
        return x;
    }

    public RealVector solveInPlace(RealLinearOperator a, RealVector b, RealVector x) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, NonSelfAdjointOperatorException, IllConditionedOperatorException, MaxCountExceededException {
        return this.solveInPlace(a, null, b, x, false, 0.0);
    }

    static {
        MACH_PREC = Math.ulp(1.0);
        CBRT_MACH_PREC = Math.cbrt(MACH_PREC);
    }

    private static class SymmLQEvent
    extends IterativeLinearSolverEvent {
        private static final long serialVersionUID = 2012012801L;
        private final transient State state;

        public SymmLQEvent(SymmLQ source, State state) {
            super(source, source.getIterationManager().getIterations());
            this.state = state;
        }

        public int getIterations() {
            return ((SymmLQ)this.getSource()).getIterationManager().getIterations();
        }

        public double getNormOfResidual() {
            return FastMath.min(this.state.cgnorm, this.state.lqnorm);
        }

        public RealVector getRightHandSideVector() {
            return RealVector.unmodifiableRealVector(this.state.b);
        }

        public RealVector getSolution() {
            int n = this.state.x.getDimension();
            ArrayRealVector x = new ArrayRealVector(n);
            this.state.refine(x);
            return x;
        }
    }

    private class State {
        private final RealLinearOperator a;
        private final RealVector b;
        private double beta;
        private double beta1;
        private double bstep;
        private double cgnorm;
        private double dbar;
        private double gammaZeta;
        private double gbar;
        private double gmax;
        private double gmin;
        private final boolean goodb;
        private boolean hasConverged;
        private double lqnorm;
        private final RealLinearOperator minv;
        private double minusEpsZeta;
        private final RealVector minvb;
        private double oldb;
        private RealVector r1;
        private RealVector r2;
        private final double shift;
        private double snprod;
        private double tnorm;
        private RealVector wbar;
        private final RealVector x;
        private RealVector y;
        private double ynorm2;

        public State(RealLinearOperator a, RealLinearOperator minv, RealVector b, RealVector x, boolean goodb, double shift) {
            this.a = a;
            this.minv = minv;
            this.b = b;
            this.x = x;
            this.goodb = goodb;
            this.shift = shift;
            this.minvb = minv == null ? b : minv.operate(b);
            this.hasConverged = false;
            this.init();
        }

        public void refine(RealVector xRefined) {
            int n = this.x.getDimension();
            if (this.lqnorm < this.cgnorm) {
                if (!this.goodb) {
                    xRefined.setSubVector(0, this.x);
                } else {
                    double step = this.bstep / this.beta1;
                    for (int i = 0; i < n; ++i) {
                        double bi = this.minvb.getEntry(i);
                        double xi = this.x.getEntry(i);
                        xRefined.setEntry(i, xi + step * bi);
                    }
                }
            } else {
                double anorm = FastMath.sqrt(this.tnorm);
                double diag = this.gbar == 0.0 ? anorm * MACH_PREC : this.gbar;
                double zbar = this.gammaZeta / diag;
                double step = (this.bstep + this.snprod * zbar) / this.beta1;
                if (!this.goodb) {
                    for (int i = 0; i < n; ++i) {
                        double xi = this.x.getEntry(i);
                        double wi = this.wbar.getEntry(i);
                        xRefined.setEntry(i, xi + zbar * wi);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        double xi = this.x.getEntry(i);
                        double wi = this.wbar.getEntry(i);
                        double bi = this.minvb.getEntry(i);
                        xRefined.setEntry(i, xi + zbar * wi + step * bi);
                    }
                }
            }
        }

        private void init() {
            this.x.set(0.0);
            this.r1 = this.b.copy();
            RealVector realVector = this.y = this.minv == null ? this.b.copy() : this.minv.operate(this.r1);
            if (this.minv != null && SymmLQ.this.check) {
                SymmLQ.checkSymmetry(this.minv, this.r1, this.y, this.minv.operate(this.y));
            }
            this.beta1 = this.r1.dotProduct(this.y);
            if (this.beta1 < 0.0) {
                SymmLQ.throwNPDLOException(this.minv, this.y);
            }
            if (this.beta1 == 0.0) {
                return;
            }
            this.beta1 = FastMath.sqrt(this.beta1);
            RealVector v = this.y.mapMultiply(1.0 / this.beta1);
            this.y = this.a.operate(v);
            if (SymmLQ.this.check) {
                SymmLQ.checkSymmetry(this.a, v, this.y, this.a.operate(this.y));
            }
            SymmLQ.daxpy(-this.shift, v, this.y);
            double alpha = v.dotProduct(this.y);
            SymmLQ.daxpy(-alpha / this.beta1, this.r1, this.y);
            double vty = v.dotProduct(this.y);
            double vtv = v.dotProduct(v);
            SymmLQ.daxpy(-vty / vtv, v, this.y);
            this.r2 = this.y.copy();
            if (this.minv != null) {
                this.y = this.minv.operate(this.r2);
            }
            this.oldb = this.beta1;
            this.beta = this.r2.dotProduct(this.y);
            if (this.beta < 0.0) {
                SymmLQ.throwNPDLOException(this.minv, this.y);
            }
            this.beta = FastMath.sqrt(this.beta);
            this.cgnorm = this.beta1;
            this.gbar = alpha;
            this.dbar = this.beta;
            this.gammaZeta = this.beta1;
            this.minusEpsZeta = 0.0;
            this.bstep = 0.0;
            this.snprod = 1.0;
            this.tnorm = alpha * alpha + this.beta * this.beta;
            this.ynorm2 = 0.0;
            this.gmin = this.gmax = FastMath.abs(alpha) + MACH_PREC;
            if (this.goodb) {
                this.wbar = new ArrayRealVector(this.a.getRowDimension());
                this.wbar.set(0.0);
            } else {
                this.wbar = v;
            }
            this.updateNorms();
        }

        private void update() {
            RealVector v = this.y.mapMultiply(1.0 / this.beta);
            this.y = this.a.operate(v);
            SymmLQ.daxpbypz(-this.shift, v, -this.beta / this.oldb, this.r1, this.y);
            double alpha = v.dotProduct(this.y);
            SymmLQ.daxpy(-alpha / this.beta, this.r2, this.y);
            this.r1 = this.r2;
            this.r2 = this.y;
            if (this.minv != null) {
                this.y = this.minv.operate(this.r2);
            }
            this.oldb = this.beta;
            this.beta = this.r2.dotProduct(this.y);
            if (this.beta < 0.0) {
                SymmLQ.throwNPDLOException(this.minv, this.y);
            }
            this.beta = FastMath.sqrt(this.beta);
            this.tnorm += alpha * alpha + this.oldb * this.oldb + this.beta * this.beta;
            double gamma = FastMath.sqrt(this.gbar * this.gbar + this.oldb * this.oldb);
            double c = this.gbar / gamma;
            double s = this.oldb / gamma;
            double deltak = c * this.dbar + s * alpha;
            this.gbar = s * this.dbar - c * alpha;
            double eps = s * this.beta;
            this.dbar = -c * this.beta;
            double zeta = this.gammaZeta / gamma;
            double zetaC = zeta * c;
            double zetaS = zeta * s;
            int n = this.x.getDimension();
            for (int i = 0; i < n; ++i) {
                double xi = this.x.getEntry(i);
                double vi = v.getEntry(i);
                double wi = this.wbar.getEntry(i);
                this.x.setEntry(i, xi + wi * zetaC + vi * zetaS);
                this.wbar.setEntry(i, wi * s - vi * c);
            }
            this.bstep += this.snprod * c * zeta;
            this.snprod *= s;
            this.gmax = FastMath.max(this.gmax, gamma);
            this.gmin = FastMath.min(this.gmin, gamma);
            this.ynorm2 += zeta * zeta;
            this.gammaZeta = this.minusEpsZeta - deltak * zeta;
            this.minusEpsZeta = -eps * zeta;
            this.updateNorms();
        }

        private void updateNorms() {
            double anorm = FastMath.sqrt(this.tnorm);
            double ynorm = FastMath.sqrt(this.ynorm2);
            double epsa = anorm * MACH_PREC;
            double epsx = anorm * ynorm * MACH_PREC;
            double epsr = anorm * ynorm * SymmLQ.this.delta;
            double diag = this.gbar == 0.0 ? epsa : this.gbar;
            this.lqnorm = FastMath.sqrt(this.gammaZeta * this.gammaZeta + this.minusEpsZeta * this.minusEpsZeta);
            double qrnorm = this.snprod * this.beta1;
            this.cgnorm = qrnorm * this.beta / FastMath.abs(diag);
            double acond = this.lqnorm <= this.cgnorm ? this.gmax / this.gmin : this.gmax / FastMath.min(this.gmin, FastMath.abs(diag));
            if (acond * MACH_PREC >= 0.1) {
                throw new IllConditionedOperatorException(acond);
            }
            if (this.beta1 <= epsx) {
                throw new SingularOperatorException();
            }
            this.hasConverged = this.cgnorm <= epsx || this.cgnorm <= epsr;
        }
    }
}

