% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refer.R
\name{refer}
\alias{refer}
\alias{refer2vector}
\title{Generate Vector Element Names}
\usage{
refer(x, fmt = "\%s_{\%.0f}", to = deparse(substitute(x)), index = 1:length(x))

refer2vector(
  x,
  fmt = "\%s_{\%.0f}",
  to = deparse(substitute(x)),
  index = 1:length(x)
)
}
\arguments{
\item{x}{vector: a vector to create the names for}

\item{fmt}{character: format string for \code{sprintf} (default: \code{"\%s_{\%.0f}"}}

\item{to}{character: base name of elements}

\item{index}{numeric: vector with indices  (default: \code{1:length(x)})}
}
\value{
A character vector
}
\description{
Creates names for elements of a vector.
}
\examples{
x <- runif(5)
refer(x)                  # LaTeX default
refer(x, fmt="\%s[\%.0f]")  # R default
}
