% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assoc.R
\name{nom.cc}
\alias{nom.cc}
\alias{cc_coef}
\alias{cramer_vf}
\alias{cramer_coef}
\alias{kendall_corr}
\alias{spearman_corr}
\alias{rs_corr}
\alias{nom.cramer}
\alias{ord.spearman}
\alias{ord.kendall}
\title{Association and Correlation Measures}
\usage{
nom.cc(tab, correct = FALSE)

nom.cramer(tab, ...)

ord.spearman(tab, ...)

ord.kendall(tab, ...)

cc_coef(tab, correct = FALSE)

cramer_vf(tab, ...)

cramer_coef(tab, ...)

kendall_corr(tab, ...)

spearman_corr(tab, ...)

rs_corr(tab, ...)
}
\arguments{
\item{tab}{A contingency table (matrix or table) with absolute frequencies.}

\item{correct}{Logical, whether to apply a correction (default: \code{FALSE}). Only used for \code{nom.cc}.}

\item{...}{Additional parameters passed to correlation functions.}
}
\value{
A numeric value representing the association or correlation measure.
}
\description{
Compute association and correlation measures for categorical and ordinal data.

The following measures are implemented:
\itemize{
\item \strong{nom.cc}: Corrected contingency coefficient for nominal data.
\item \strong{nom.cramer}: Cramer's V (or Phi) for nominal data.
\item \strong{ord.spearman}: Spearman's rank correlation for ordinal data.
\item \strong{ord.kendall}: Kendall's rank correlation for ordinal data.
}
}
\details{
These functions provide common measures of association:
\itemize{
\item Nominal data: \code{nom.cc}, \code{nom.cramer}.
\item Ordinal data: \code{ord.spearman}, \code{ord.kendall}.
}
}
\examples{
# Create a random contingency table
tab <- matrix(round(10 * runif(15)), ncol = 5)

# Nominal association
nom.cc(tab)
nom.cc(tab, correct = TRUE)
nom.cramer(tab)

# Ordinal correlation
ord.spearman(tab)
ord.kendall(tab)

# Using aliases
cc_coef(tab)
cramer_vf(tab)
spearman_corr(tab)
kendall_corr(tab)
rs_corr(tab)
}
