% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assoc_data.R
\name{assoc_data}
\alias{assoc_data}
\alias{reorder_association_data}
\alias{dassoc}
\title{Frequency Optimization}
\usage{
assoc_data(
  tab,
  zero = FALSE,
  FUN = nom.cc,
  target = NA,
  tol = 0.001,
  maxit = 500,
  ...
)

reorder_association_data(
  tab,
  zero = FALSE,
  FUN = nom.cc,
  target = NA,
  tol = 0.001,
  maxit = 500,
  ...
)

dassoc(
  tab,
  zero = FALSE,
  FUN = nom.cc,
  target = NA,
  tol = 0.001,
  maxit = 500,
  ...
)
}
\arguments{
\item{tab}{table: table of absolute frequencies}

\item{zero}{logical: zeros are allowed in the final probabilities (default: \code{FALSE})}

\item{FUN}{function: association or correlation function (default: \code{nom.cc})}

\item{target}{numeric: target association or correlation (default: \code{NA})}

\item{tol}{numeric: tolerance for target association or correlation (default: \code{0.001})}

\item{maxit}{integer: maximal number of iterations (default: \code{100})}

\item{...}{further parameters}
}
\value{
a modified frequency table
}
\description{
Given a frequency table, the function reorders the observations such that the given \code{target} association will be approximated and the marginal
frequencies remain unchanged. Note that the \code{target} association may not be reached!
\code{zero} allows for zero entries in the common distribution.
If \code{target} is \code{NA} then the table is simply returned. \code{FUN} computes the association (or correlation) measure based on a
frequency table. \code{tol} gives the maximal deviation of the association (or correlation) measure
and the \code{target} value. \code{maxit} limits the number of steps.
Please note that a solution is not guaranteed, especially for extreme values of \code{target}, for example
for \eqn{+1}, \eqn{-1} or nearby values.
If \code{attr(joint, "iterations")== maxit} then you need either to increase \code{maxit}, to decrease \code{tol}, or
check if you have chosen an appropriate \code{target} value (for a nominal measure in \eqn{0 <= target <= 1}, for ordinal measure in \eqn{-1 <= target <= +1}).
\code{attr(joint, "target")} contains the achieved association.
}
\examples{
tab <- table_data(3, 2)
tab
tab2 <- assoc_data(tab, target=0.5)
tab2
}
