% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metric_calV}
\alias{metric_calV}
\title{Parasite dispersal by mosquitoes}
\usage{
metric_calV(f, q, Omega, tau, M, W)
}
\arguments{
\item{f}{the feeding rate}

\item{q}{fraction of bloodmeals taken on humans}

\item{Omega}{the mosquito demography matrix}

\item{tau}{duration of the extrinsic incubation period}

\item{M}{size of mosquito population in each patch}

\item{W}{ambient human population at each patch}
}
\value{
a numeric \link{matrix}
}
\description{
Compute the \code{p} by \code{p} matrix \eqn{\mathcal{V}} whose columns describe
how infective bites arising from all the mosquitoes biting a single human on a
single day are dispersed to other patches, accounting for movement and mortality.
\deqn{\mathcal{V} = fq\Omega^{-1} \cdot e^{-\Omega\tau} \cdot \mbox{diag}\left(\frac{fqM}{W}\right)}
}
