% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{plot_bivarGMM}
\alias{plot_bivarGMM}
\title{Plot Bivariate Gaussian Mixture Models}
\usage{
plot_bivarGMM(
  sessions,
  models,
  profiles_names = seq(1, nrow(models)),
  points_size = 0.25,
  lines_size = 1,
  legend_nrow = 2,
  log = FALSE,
  start = getOption("evprof.start.hour")
)
}
\arguments{
\item{sessions}{tibble, sessions data set in evprof
\href{https://mcanigueral.github.io/evprof/articles/sessions-format.html}{standard format}.}

\item{models}{tibble, parameters of the clusters' GMM models obtained with
function \code{cluster_sessions} (object \code{models} of the returned list)}

\item{profiles_names}{names of profiles}

\item{points_size}{size of scatter points in the plot}

\item{lines_size}{size of lines in the plot}

\item{legend_nrow}{number of rows in legend}

\item{log}{logical, whether to transform \code{ConnectionStartDateTime} and
\code{ConnectionHours} variables to natural logarithmic scale (base = \code{exp(1)}).}

\item{start}{integer, start hour in the x axis of the plot.}
}
\value{
ggplot2 plot
}
\description{
Plot Bivariate Gaussian Mixture Models
}
\examples{
library(dplyr)

# Select working day sessions (`Timecycle == 1`) that
# disconnect the same day (`Disconnection == 1`)
sessions_day <- california_ev_sessions \%>\%
  divide_by_timecycle(
    months_cycles = list(1:12), # Not differentiation between months
    wdays_cycles = list(1:5, 6:7) # Differentiation between workdays/weekends
  ) \%>\%
  divide_by_disconnection(
    division_hour = 10, start = 3
  ) \%>\%
  filter(
    Disconnection == 1, Timecycle == 1
  ) \%>\%
  sample_frac(0.05)
plot_points(sessions_day, start = 3)

# Identify two clusters
sessions_clusters <- cluster_sessions(
  sessions_day, k=2, seed = 1234, log = TRUE
)

# Plot the clusters found
plot_bivarGMM(
  sessions = sessions_clusters$sessions,
  models = sessions_clusters$models,
  log = TRUE, start = 3
)

}
