% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MantelCor.R
\name{MantelCor}
\alias{MantelCor}
\alias{MantelCor.default}
\alias{MantelCor.list}
\alias{MantelCor.mcmc_sample}
\alias{MatrixCor}
\alias{MatrixCor.default}
\alias{MatrixCor.list}
\alias{MatrixCor.mcmc_sample}
\title{Compare matrices via Mantel Correlation}
\usage{
MantelCor(cor.x, cor.y, ...)

\method{MantelCor}{default}(
  cor.x,
  cor.y,
  permutations = 1000,
  ...,
  landmark.dim = NULL,
  withinLandmark = FALSE,
  mod = FALSE
)

\method{MantelCor}{list}(
  cor.x,
  cor.y = NULL,
  permutations = 1000,
  repeat.vector = NULL,
  parallel = FALSE,
  ...
)

\method{MantelCor}{mcmc_sample}(cor.x, cor.y, ..., parallel = FALSE)

MatrixCor(cor.x, cor.y, ...)

\method{MatrixCor}{default}(cor.x, cor.y, ...)

\method{MatrixCor}{list}(
  cor.x,
  cor.y = NULL,
  permutations = 1000,
  repeat.vector = NULL,
  parallel = FALSE,
  ...
)

\method{MatrixCor}{mcmc_sample}(cor.x, cor.y, ..., parallel = FALSE)
}
\arguments{
\item{cor.x}{Single correlation matrix or list of correlation matrices.

If single matrix is supplied, it is compared to cor.y.

If list is supplied and no cor.y is supplied, all matrices
are compared.

If cor.y is supplied, all matrices in list are compared to it.}

\item{cor.y}{First argument is compared to cor.y.
Optional if cor.x is a list.}

\item{...}{additional arguments passed to other methods}

\item{permutations}{Number of permutations used in significance calculation.}

\item{landmark.dim}{Used if permutations should be performed maintaining landmark structure in geometric morphometric data. Either 2 for 2d data or 3 for 3d data. Default is NULL for non geometric morphomotric data.}

\item{withinLandmark}{Logical. If TRUE within-landmark correlations are used in the calculation of matrix correlation. Only used if landmark.dim is passed, default is FALSE.}

\item{mod}{Set TRUE to use mantel in testing modularity hypothesis. Should only be used in MantelModTest.}

\item{repeat.vector}{Vector of repeatabilities for correlation correction.}

\item{parallel}{if TRUE computations are done in parallel. Some foreach back-end must be registered, like doParallel or doMC.}
}
\value{
If cor.x and cor.y are passed, returns matrix Pearson
correlation coefficient and significance via Mantel permutations.

If cor.x is a list of matrices and cor.y is passed, same as above, but for all matrices in cor.x.

If only cor.x is passed, a matrix of MantelCor average
values and probabilities of all comparisons.
If repeat.vector is passed, comparison matrix is corrected above
diagonal and repeatabilities returned in diagonal.
}
\description{
Calculates correlation matrix correlation and significance via Mantel test.
}
\note{
If the significance is not needed, MatrixCor provides the 
correlation and skips the permutations, so it is much faster.
}
\examples{
c1 <- RandomMatrix(10, 1, 1, 10)
c2 <- RandomMatrix(10, 1, 1, 10)
c3 <- RandomMatrix(10, 1, 1, 10)
MantelCor(cov2cor(c1), cov2cor(c2))

cov.list <- list(c1, c2, c3)
cor.list <- llply(list(c1, c2, c3), cov2cor)

MantelCor(cor.list)

# For repeatabilities we can use MatrixCor, which skips the significance calculation
reps <- unlist(lapply(cov.list, MonteCarloRep, 10, MatrixCor, correlation = TRUE))
MantelCor(cor.list, repeat.vector = reps)

c4 <- RandomMatrix(10)
MantelCor(cor.list, c4)

#Multiple threads can be used with some foreach backend library, like doMC or doParallel
#library(doParallel)
##Windows:
#cl <- makeCluster(2)
#registerDoParallel(cl)
##Mac and Linux:
#registerDoParallel(cores = 2)
#MantelCor(cor.list, parallel = TRUE) 
}
\references{
http://en.wikipedia.org/wiki/Mantel_test
}
\seealso{
\code{\link{KrzCor}},\code{\link{RandomSkewers}},\code{\link{mantel}},\code{\link{RandomSkewers}},\code{\link{TestModularity}}, \code{\link{MantelModTest}}
}
\author{
Diogo Melo, Guilherme Garcia
}
\keyword{matrixcomparison}
\keyword{matrixcorrelation}
\keyword{randomskewers}
