% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt.joint.OUBM.R
\name{opt.joint.OUBM}
\alias{opt.joint.OUBM}
\title{Fit an Ornstein-Uhlenbeck model with an optimum that evolves according to a Unbiased Random Walk.}
\usage{
opt.joint.OUBM(
  y,
  pool = TRUE,
  meth = "L-BFGS-B",
  hess = FALSE,
  iterations = NULL,
  iter.sd = NULL,
  opt.anc = TRUE
)
}
\arguments{
\item{y}{an univariate paleoTS object.}

\item{pool}{logical indicating whether to pool variances across samples}

\item{meth}{optimization method, passed to function optim. Default is "L-BFGS-B".}

\item{hess}{logical, indicating whether to calculate standard errors from the Hessian matrix.}

\item{iterations}{the number of times the optimization method is run from different starting points. Default is NULL, meaning the optimization is run once.}

\item{iter.sd}{defines the standard deviation of the Gaussian distribution from which starting values for the optimization routine is run. Default is 1.}

\item{opt.anc}{logical, indicating whether the the ancestral trait state is at the optimum.}
}
\value{
\item{logL}{the log-likelihood of the optimal solution}
\item{AICc}{AIC with a correction for small sample sizes}
\item{parameters}{parameter estimates}
\item{modelName}{abbreviated model name}
\item{method}{Joint consideration of all samples}
\item{K}{number of parameters in the model}
\item{n}{the number of observations/samples}
}
\description{
Function to find maximum likelihood solutions to an Ornstein-Uhlenbeck model with an optimum that evolves according to a Unbiased Random Walk.
}
\note{
The models have been implemented to be compatible with the joint parameterization routine in the package paleoTS. The optimization is therefore fit using the actual sample values, with the autocorrelation among samples accounted for in the log-likelihood function. The joint distribution of sample means is multivariate normal, with means and variance-covariances determined by evolutionary parameters and sampling errors.
}
\examples{
## Generate a paleoTS object by simulating a univariate evolutionary sequence
x <- paleoTS::sim.GRW(60)

## Fit the model
opt.joint.OUBM(x)

}
\references{
Hansen, T. F., Pienaar, J. & Orzack, S. H. 2008. A Comparative Method for Studying Adaptation to a Randomly Evolving Environment. \emph{Evolution} 62:1965–1977.
}
\author{
Kjetil Lysne Voje
}
