% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gev_influence.R
\name{gev_influence}
\alias{gev_influence}
\alias{plot.gev_influence}
\title{GEV influence curves}
\usage{
gev_influence(z, mu = 0, sigma = 1, xi = 0)

\method{plot}{gev_influence}(x, xvar = c("z", "y"), sep_xi = TRUE, vlines, ...)
}
\arguments{
\item{z}{A numeric vector. Values of normal quantiles \eqn{z} at which to
calculate the GEV influence function. See \strong{Details}.}

\item{mu, sigma, xi}{Numeric scalars supplying the values of the GEV
parameters \eqn{\mu}, \eqn{\sigma} and \eqn{\xi}.}

\item{x}{An object inheriting from class \code{"gev_influence"}, from a call to
\code{\link{gev_influence}}.}

\item{xvar}{A logical scalar.
If \code{xvar = "z"} then the influence curves are plotted against the standard
normal quantiles in \code{x[, "z"]}.
If \code{xvar = "y"} then the influence curves are plotted against the
corresponding GEV quantiles in \code{x[, "y"]}.}

\item{sep_xi}{A logical scalar. If \code{sep_xi = TRUE} then separate vertical
scales are used for \eqn{\xi} and \eqn{(\mu, \sigma)}. The scale for
\eqn{\xi} appears on the left and the scale for \eqn{(\mu, \sigma)} on the
right.}

\item{vlines}{A numeric vector. If \code{vlines} is supplied then black dashed
vertical lines are added to the plot at the values in \code{vlines} on the
horizontal axis. This might be used to indicate the values of certain
observations in a dataset.}

\item{...}{For \code{plot.gev_influence}: to pass graphical parameters to the
graphical functions \code{\link[graphics:plot.default]{matplot}} and
\code{\link[graphics:legend]{legend}}. The parameters \verb{col, lty} and \code{lwd} can be
used to control line colour, type and width, with the parameters in the
usual order, that is, \eqn{(\mu, \sigma, \xi)}.}
}
\value{
\code{gev_influence}: an object with class
\code{c("gev_influence", "matrix", "array")}, a \code{length(z)} by \code{5} numeric
matrix. The first two columns contain the input values in \code{z} and the
corresponding values of \code{y}. Columns 3-5 contain the values of the GEV
influence function for \eqn{\mu}, \eqn{\sigma} and \eqn{\xi} respectively
at the values of \code{z}.

\code{plot.gev_influence}: a list of the graphical parameters used in producing
the plot, either the defaults or supplied via \code{...}, is returned
invisibly.
}
\description{
Calculates influence function curves for maximum likelihood estimators of
Generalised Extreme Value (GEV) parameters.
}
\details{
An influence function measures the effect on a parameter estimator
of changing one observation in a sample. See Hampel (2005) and, in the
context of extreme value analyses of threshold exceedances,
Davison and Smith (1990).
Let \eqn{\theta = (\mu, \sigma, \xi)}. The GEV influence curve is defined,
as a function of an observation \eqn{y}, by
\eqn{IC(y) = \{IC_{\mu}(y), IC_{\sigma}(y), IC_{\xi}(y)\} =
  i_\theta^{-1} {\rm d}\ell(y; \theta)/{\rm d} \theta},
where \eqn{\ell(y; \theta)} is the GEV log-likelihood function and
\eqn{i_\theta^{-1}} is the GEV expected information matrix.
The value of \eqn{y} is related to \eqn{z} by
\eqn{y = G^{-1}\{\Phi(z)\}}, where \eqn{\Phi} and \eqn{G} are the
distribution functions of a standard normal and
GEV(\eqn{\mu, \sigma, \xi}) distribution, respectively. Plotting influence
curves on the standard normal \code{z} scale can help to aid interpretation.

The value of \eqn{IC(y)} is invariant to the value of \eqn{\mu}.
For a given value of \eqn{\xi}, the values of \eqn{IC_{\mu}(y)} and
\eqn{IC_{\sigma}(y)} scale with the scale parameter \eqn{\sigma}, that is,
doubling \eqn{\sigma} doubles \eqn{IC_{\mu}(y)} and \eqn{IC_{\sigma}(y).}
Typically, interest focuses on the shape parameter \eqn{\xi}, but if the
input scale parameter \eqn{\sigma} is large then this may hide the
influence of \eqn{y} on \eqn{\xi}. Therefore, the default setting of
\code{plot.gev_influence}, \code{sep_xi = TRUE}, separates the plotting of the
influence curve for \eqn{\xi} from those of \eqn{\mu} and \eqn{\sigma}.

The example in \strong{Examples} shows that extremely large block maxima have a
strong positive influence on the MLE \eqn{\hat{\xi}} and also that
extremely small block maxima have a strong negative influence on
\eqn{\hat{\xi}},
}
\examples{
# Influence curve for the default mu = 0, sigma = 1, xi = 0 case
z <- seq(from = -3, to = 3, by = 0.01)
inf <- gev_influence(z = z)
plot(inf)

# Influence curves based on the adjusted fit to the Plymouth ozone data
fit <- gev_mle(PlymouthOzoneMaxima)
pars <- coef(fit)
infp <- gev_influence(z = z, mu = pars[1], sigma = pars[2], xi = pars[3])
plot(infp)
}
\references{
Hampel, F. R., Ronchetti, E. M., Rousseeuw, P. J., and
Stahel, W. A. (2005). Robust Statistics. Wiley-Interscience, New York.
\doi{10.1002/9781118186435}

Davison, A. C. and Smith, R. L. (1990). Models for exceedances
over high thresholds. Journal of the Royal Statistical Society: Series B
(Methodological), 52(3):393–425. \doi{10.1111/j.2517-6161.1990.tb01796.x}
}
\seealso{
\code{\link{gev_influence_rl}}
}
