% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_evzinb.R
\name{tidy.evinb}
\alias{tidy.evinb}
\title{EVINB tidy function}
\usage{
\method{tidy}{evinb}(
  x,
  component = c("evi", "count", "pareto", "all"),
  coef_type = c("original", "bootstrap_mean", "bootstrap_median"),
  standard_error = TRUE,
  p_value = c("bootstrapped", "approx", "none"),
  confint = c("none", "bootstrapped", "approx"),
  conf_level = 0.95,
  approx_t_value = TRUE,
  symmetric_bootstrap_p = TRUE,
  ...
)
}
\arguments{
\item{x}{An evinb object}

\item{component}{Which component should be shown?}

\item{coef_type}{Type of coefficients. Original are the coefficient estimates from the non-bootstrapped version of the model. 'bootstrapped_mean' are the mean coefficients across bootstraps, and 'bootstrapped_median' are the median coefficients across bootstraps}

\item{standard_error}{Should standard errors be computed?}

\item{p_value}{What type of p_values should be computed? 'bootstrapped' are bootstrapped p_values through confidence interval inversion. 'approx' are p-values based on the t-value produced by dividing the coefficient with the standard error.}

\item{confint}{What type of confidence should be computed. Same options as p_value}

\item{conf_level}{What confidence level should be used for the confidence interval}

\item{approx_t_value}{Should approximate t-values be returned}

\item{symmetric_bootstrap_p}{Should bootstrap p-values be computed as symmetric (leaving alpha/2 percent in each tail)? FALSE gives non-symmetric, but narrower, intervals. TRUE corresponds most closely to conventional p-values.}

\item{...}{Other arguments passsed to tidy function}
}
\value{
An EVINB tidy function
}
\description{
EVINB tidy function
}
\examples{
data(genevzinb2)
model <- evinb(y~x1+x2+x3,data=genevzinb2, n_bootstraps = 10, multicore = TRUE, ncores = 2)
tidy(model)

}
