% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{plot.evgam}
\alias{plot.evgam}
\title{Plot a fitted \code{evgam} object}
\usage{
\method{plot}{evgam}(
  x,
  given.vals = NULL,
  use.image = FALSE,
  add.map = FALSE,
  map.env = "world",
  ...
)
}
\arguments{
\item{x}{a fitted \code{evgam} object}

\item{given.vals}{a list specifying variables values that are fixed.}

\item{use.image}{logical: should \link[graphics]{image} be used to represent two-dimensional smooths, as opposed to \link[graphics]{contour}? Defaults to \code{FALSE}}

\item{add.map}{logical: should a map outline be added to any two-dimensional smooths using \link[maps]{map}? Defaults to \code{FALSE}}

\item{map.env}{a character string identifying the map to superimpose via \link[maps]{map}; defaults to \code{"world"}}

\item{...}{unused}
}
\value{
Plots representing all one- or two-dimensional smooths
}
\description{
Plot a fitted \code{evgam} object
}
\examples{

data(fremantle)
fmla_gev <- list(SeaLevel ~ s(Year, k=5, bs="cr"), ~ 1, ~ 1)
m_gev <- evgam(fmla_gev, fremantle, family = "gev")
plot(m_gev)

}
