% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{print.evgam}
\alias{print.evgam}
\title{Print a fitted \code{evgam} object}
\usage{
\method{print}{evgam}(x, ...)
}
\arguments{
\item{x}{a fitted \code{evgam} object}

\item{...}{not used}
}
\value{
The call of the \code{evgam} object
}
\description{
Print a fitted \code{evgam} object
}
\examples{
\donttest{

library(evgam)
data(COprcp)
COprcp$year <- format(COprcp$date, "\%Y")
COprcp_gev <- aggregate(prcp ~ year + meta_row, COprcp, max)
COprcp_gev <- cbind(COprcp_gev, COprcp_meta[COprcp_gev$meta_row,])
fmla_gev <- list(prcp ~ s(lon, lat, k=30) + s(elev, bs="cr"), ~ s(lon, lat, k=20), ~ 1)
m_gev <- evgam(fmla_gev, data=COprcp_gev, family="gev")
print(m_gev)

}

}
