% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackknife-cuminc.R
\name{jackknife.survival2}
\alias{jackknife.survival2}
\title{Compute jackknife pseudo-observations of the survival function}
\usage{
jackknife.survival2(object, times, mr)
}
\arguments{
\item{object}{A survfit object, with a single event (no competing risks)}

\item{times}{Times at which the survival is computed, must be length 1}

\item{mr}{Model response, the result of a call to Surv, or a matrix with two columns: "time" (observed follow up time) and "status" (0 = censored, 1 = event)}
}
\value{
A vector of jackknifed estimates of survival at time times
}
\description{
Compute jackknife pseudo-observations of the survival function
}
\examples{

sfit.surv <- survival::survfit(survival::Surv(time, status) ~ 1, data = colon)
mrs <- with(colon, Surv(time, status))
pseudo.obs <- jackknife.survival2(sfit.surv, times = 1000, mrs)
mean(pseudo.obs)
# agrees with
summary(sfit.surv, times = 1000)
}
