% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{pwexpreg}
\alias{pwexpreg}
\title{Piecewise exponential regression}
\usage{
pwexpreg(data, tcut = 0, event = "event", covariates = NULL)
}
\arguments{
\item{data}{The input data frame. It should contain \code{time},
\code{event}, and variables specified in \code{covariates}.}

\item{tcut}{A vector that specifies the time intervals
for the piecewise exponential survival distribution.
Must start with 0, e.g., c(0, 60) breaks the time axis into 2 event
intervals: [0, 60) and [60, Inf). By default, it is set to 0.}

\item{event}{The variable name indicating event, e.g. "event" or
"dropout".}

\item{covariates}{The names of baseline covariates in
the input data frame, e.g., c("age", "sex").
Factor variables need to declared in the input data frame.}
}
\value{
The maximum likelihood estimates and the associated
covariance matrix, AIC and BIC.
}
\description{
Obtains the maximum likelihood estimates for piecewise
exponential regression.
}
