% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openfair.R
\name{compare_tef_vuln}
\alias{compare_tef_vuln}
\title{Calculate number of loss events which occur in a simulated period}
\usage{
compare_tef_vuln(tef, vuln, n = NULL)
}
\arguments{
\item{tef}{Threat event frequency (n).}

\item{vuln}{Vulnerability (percentage).}

\item{n}{Number of samples to generate.}
}
\value{
List containing samples (as a vector) and details (as a list).
}
\description{
Composition function for use in \code{\link{sample_lef}}. Given a count of
the number of threat events (TEF) and the level of vulnerability (as a
percentage), calculate how many of those become loss events (LEF).
}
\examples{
compare_tef_vuln(tef = 500, vuln = .25)
}
\seealso{
Other OpenFAIR helpers: 
\code{\link{get_mean_control_strength}()},
\code{\link{openfair_tef_tc_diff_lm}()},
\code{\link{sample_diff}()},
\code{\link{sample_lef}()},
\code{\link{sample_lm}()},
\code{\link{sample_tc}()},
\code{\link{sample_vuln}()},
\code{\link{select_loss_opportunities}()}
}
\concept{OpenFAIR helpers}
