% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gpd.R
\name{rgpd}
\alias{dgpd}
\alias{pgpd}
\alias{qgpd}
\alias{rgpd}
\title{The Generalized Pareto Distribution (GPD)}
\usage{
rgpd(n, loc = 0, scale = 1, shape = 0)

pgpd(q, loc = 0, scale = 1, shape = 0, lower.tail = TRUE,
  log.p = FALSE)

dgpd(x, loc = 0, scale = 1, shape = 0, log.d = FALSE)

qgpd(p, loc = 0, scale = 1, shape = 0, lower.tail = TRUE,
  log.p = FALSE)
}
\arguments{
\item{n}{Number of observations.}

\item{loc}{Location parameter.}

\item{scale}{Scale parameter.}

\item{shape}{Shape parameter.}

\item{q}{Vector of quantiles.}

\item{lower.tail}{Logical; if TRUE (default), probabilities are P[X <= x], otherwise, P[X > x].}

\item{log.p}{Logical; if TRUE, probabilities p are given as log(p).}

\item{x}{Vector of observations.}

\item{log.d}{Logical; if TRUE, the log density is returned.}

\item{p}{Vector of probabilities.}
}
\description{
Density, distribution function, quantile function and random number generation for the Generalized Pareto
distribution with location, scale, and shape parameters.
}
\details{
The Genralized Pareto distribution function is given (Pickands, 1975)
by \deqn{H(y) = 1 - \Big[1 + \frac{\xi (y - \mu)}{\sigma}\Big]^{-1/\xi}} defined
on \eqn{\{y : y > 0, (1 + \xi (y - \mu) / \sigma) > 0 \}}, with location \eqn{\mu},
scale \eqn{\sigma}, and shape parameter \eqn{\xi}.
}
\examples{
dgpd(2:4, 1, 0.5, 0.8)
}
\references{
Pickands III, J. (1975). Statistical inference using extreme order statistics. Annals of Statistics, 119-131.
}

