% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eurotime2num.R
\name{eurotime2num2}
\alias{eurotime2num2}
\title{Conversion of Eurostat Time Format to Numeric}
\usage{
eurotime2num2(x)
}
\arguments{
\item{x}{a charter string with time information in Eurostat time format.}
}
\value{
see \code{\link[=as.numeric]{as.numeric()}}.
}
\description{
A conversion of a Eurostat time format to numeric.
}
\details{
Bi-annual (semester), quarterly, monthly and weekly data can be presented as
a fraction of the year in beginning of the period. Conversion of daily data
is not supported.
}
\examples{
\dontshow{if (check_access_to_data()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
na_q <- get_eurostat("namq_10_pc", time_format = "raw")
na_q$time <- eurotime2num(x = na_q$time)

unique(na_q$time)
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other helpers: 
\code{\link{cut_to_classes}()},
\code{\link{dic_order}()},
\code{\link{eurotime2date2}()},
\code{\link{eurotime2date}()},
\code{\link{eurotime2num}()},
\code{\link{harmonize_country_code}()},
\code{\link{label_eurostat2}()},
\code{\link{label_eurostat}()}
}
\author{
Janne Huovari \href{mailto:janne.huovari@ptt.fi}{janne.huovari@ptt.fi}, Pyry Kantanen
}
\concept{helpers}
