#' Brief summary of the eurostat package
#'
#' |              |          |
#' | :---         | :--      |
#' | **Package**  | eurostat |
#' | **Type**     | Package  |
#' | **Version**  | `r packageVersion("eurostat")` |
#' | **Date**     | 2014-2021     |
#' | **License**  | `r as.character(utils::packageDescription("eurostat")["License"])`|
#' | **LazyLoad** | yes      |
#'
#'
#' R Tools for Eurostat Open Data
#'
#' @name eurostat-package
#' @aliases eurostat
#' @docType package
#' @title R Tools for Eurostat open data
#'
#' @author Leo Lahti, Janne Huovari, Markus Kainu, Przemyslaw Biecek
#' @references
#' See `citation("eurostat")`:
#'
#' ```{r, echo=FALSE, comment="#" }
#' citation("eurostat")
#' ```
#' @examples library(eurostat)
#' @section regions functions:
#' For working with sub-national statistics the basic functions of the
#' regions package are imported <https://regions.dataobservatory.eu/>.
#' @keywords package
#' @seealso `help("regions")`, <https://regions.dataobservatory.eu/>
NULL
