% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epmc_search.r
\name{epmc_search}
\alias{epmc_search}
\title{Search Europe PMC publication database}
\usage{
epmc_search(query = NULL, limit = 25, id_list = FALSE, synonym = FALSE,
  verbose = TRUE)
}
\arguments{
\item{query}{character, search query. For more information on how to
build a search query, see \url{http://europepmc.org/Help}}

\item{limit}{integer, limit the number of records you wish to retrieve.
By default, 25 are returned.}

\item{id_list}{logical, should only IDs (e.g. PMID) and sources be retrieved
for the given search terms?}

\item{synonym}{logical, synonym search. If TRUE, synonym terms from MeSH
terminology and the UniProt synonym list are queried, too. Disabled by
default.}

\item{verbose}{logical, print some information on what is going on.}
}
\value{
data.frame
}
\description{
This is the main function to search
Europe PMC RESTful Web Service (\url{http://europepmc.org/RestfulWebService})
}
\examples{
\dontrun{
#Search articles for 'Gabi-Kat'
my.data <- epmc_search(query='Gabi-Kat')

#Get article metadata by DOI
my.data <- epmc_search(query = 'DOI:10.1007/bf00197367')

#Get article metadata by PubMed ID (PMID)
my.data <- epmc_search(query = 'EXT_ID:22246381')

#Get only PLOS Genetics article with EMBL database references
my.data <- epmc_search(query = 'ISSN:1553-7404 HAS_EMBL:y')
#Limit search to 250 PLOS Genetics articles
my.data <- epmc_search(query = 'ISSN:1553-7404', limit = 250)

# include mesh and uniprot synonyms in search
my.data <- epmc_search(query = 'aspirin', synonym = TRUE)

# print number of records found
attr(my.data, "hit_count")

}
}
\seealso{
\url{http://europepmc.org/Help}
}

