% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epmc_lablinks.r
\name{epmc_lablinks}
\alias{epmc_lablinks}
\title{Get links to external sources}
\usage{
epmc_lablinks(ext_id = NULL, data_src = "med", lab_id = NULL,
  n_pages = 20)
}
\arguments{
\item{ext_id}{publication identifier}

\item{data_src}{data source, by default Pubmed/MedLine index will be searched.
The following three letter codes represents the sources
Europe PubMed Central supports:
\describe{
  \item{agr}{Agricola is a bibliographic database of citations to the
  agricultural literature created by the US National Agricultural Library
  and its co-operators.}
  \item{cba}{Chinese Biological Abstracts}
  \item{ctx}{CiteXplore}
  \item{eth}{EthOs Theses, i.e. PhD theses (British Library)}
  \item{hir}{NHS Evidence}
  \item{med}{PubMed/Medline NLM}
  \item{nbk}{Europe PMC Book metadata}
  \item{pat}{Biological Patents}
  \item{pmc}{PubMed Central}
  }}

\item{lab_id}{identifier of the external link service. Use Europe PMC's
advanced search form to find an id.}

\item{n_pages}{Number of pages to be returned. By default, this function
returns 10 records for each page.}
}
\value{
Links found as data.frame
}
\description{
With the External Link services, Europe PMC allows third parties to publish
links from Europe PMC to other webpages or tools. Current External Link
providers, which can be selected through Europe PMC's advanced search,
include Wikipedia, Dryad Digital Repository or the institutional repo of
Bielefeld University. For more information, see
\url{http://europepmc.org/labslink}.
}
\examples{
  \dontrun{
  # Links to PANGEA (lab_id = 1342)
  epmc_lablinks("24023770", lab_id = "1342")

  # Links to Wikipedia
  epmc_lablinks("24007304", lab_id = "1507")

  # Link to full text copy archived through the institutional repo of
  Bielefeld University
  epmc_lablinks("12736239", lab_id = "1056")
  }
}

