% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotpole_nc_point_to_dt.R
\name{rotpole_nc_point_to_dt}
\alias{rotpole_nc_point_to_dt}
\title{Extract time series of a single grid cell of a rot-pole daily netcdf to
data.table}
\usage{
rotpole_nc_point_to_dt(
  filename,
  variable,
  point_lon,
  point_lat,
  interpolate_to_standard_calendar = FALSE,
  verbose = FALSE,
  add_grid_coord = FALSE
)
}
\arguments{
\item{filename}{Complete path to .nc file.}

\item{variable}{Name of the variable to extract from \code{filename}
(character).}

\item{point_lon}{Numeric longitude of the point to extract (decimal degrees).}

\item{point_lat}{Numeric latitude of the point to extract (decimal degrees).}

\item{interpolate_to_standard_calendar}{Boolean, if \code{TRUE} will use
\code{\link{map_non_standard_calendar}} to interpolate values to a standard
calendar.}

\item{verbose}{Boolean, if \code{TRUE}, will print more information.}

\item{add_grid_coord}{Boolean, if \code{TRUE}, will add columns to the result
which give the longitude and latitude of the underlying grid.}
}
\value{
A \code{\link[data.table]{data.table}} with two columns: the dates in
  date, and the values in a variable named after input \code{variable}. The
  date column is of class \code{\link{Date}}, unless the .nc
  file has a non-standard calendar (360, noleap) and
  \code{interpolate_to_standard_calendar} is set to \code{FALSE}, in which it
  will be character. If \code{add_grid_coord} is set to \code{TRUE}, then
  two more columns named grid_lon and grid_lat.
}
\description{
Creates a \code{\link[data.table]{data.table}} from a rotated pole netcdf (as
usually found in RCMs), which includes values and date. Useful for extracting
e.g. the series for a station. Requires that dimension variables in netcdf
file contain rlon and rlat, and that it contains daily data.
}
\details{
Calculates the euclidean distance, and takes the grid cell with minimal
distance to \code{point_lon} and \code{point_lat}. Requires that the .nc file
contains variables lon[rlon, rlat] and lat[rlon, rlat].
}
\examples{
# example data from EURO-CORDEX (cropped for size)

# standard calendar
fn1 <- system.file("extdata", "test1.nc", package = "eurocordexr")
dt1 <- rotpole_nc_point_to_dt(
  filename = fn1,
  variable = "tasmin",
  point_lon = 11.31,
  point_lat = 46.5,
  verbose = TRUE
)

# non-standard calendar (360)
fn2 <- system.file("extdata", "test2.nc", package = "eurocordexr")

# read as is
dt2 <- rotpole_nc_point_to_dt(fn2, "tasmin", 11.31, 46.5)
str(dt2) # chr date
dt2[86:94, ] # e.g. 30th of February in 360 calendar

# interpolate to standard
dt3 <- rotpole_nc_point_to_dt(fn2, "tasmin", 11.31, 46.5,
                              interpolate_to_standard_calendar = TRUE)
str(dt3) # class Date
dt3[86:94, ] # standard calender

}
