% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.euler.R
\name{plot.euler}
\alias{plot.euler}
\alias{plot.venn}
\title{Plot Euler and Venn diagrams}
\usage{
\method{plot}{euler}(x, fills = TRUE, edges = TRUE, legend = FALSE,
  labels = identical(legend, FALSE), quantities = FALSE,
  strips = NULL, main = NULL, n = 200L, ...)

\method{plot}{venn}(x, fills = TRUE, edges = TRUE, legend = FALSE,
  labels = identical(legend, FALSE), quantities = TRUE,
  strips = NULL, main = NULL, n = 200L, ...)
}
\arguments{
\item{x}{an object of class \code{'euler'}, generated from \code{\link[=euler]{euler()}}}

\item{fills}{a logical, vector, or list of graphical parameters for the fills
in the diagram. Vectors are assumed to be colors for the fills.
See \code{\link[grid:grid.path]{grid::grid.path()}}.}

\item{edges}{a logical, vector, or list of graphical parameters for the edges
in the diagram. Vectors are assumed to be colors for the edges.
See \code{\link[grid:grid.polyline]{grid::grid.polyline()}}.}

\item{legend}{a logical scalar or list. If a list,
the item \code{side} can be used to set the location of the legend. See
\code{\link[grid:grid.legend]{grid::grid.legend()}}.}

\item{labels}{a logical, vector, or list. Vectors are assumed to be
text for the labels. See \code{\link[grid:grid.text]{grid::grid.text()}}.}

\item{quantities}{a logical, vector, or list. Vectors are assumed to be
text for the quantities' labels, which by
default are the original values in the input to \code{\link[=euler]{euler()}}. See
\code{\link[grid:grid.text]{grid::grid.text()}}.}

\item{strips}{a list, ignored unless the \code{'by'} argument
was used in \code{\link[=euler]{euler()}}}

\item{main}{a title for the plot in the form of a
character, expression, list or something that can be
sensibly converted to a label via \code{\link[grDevices:as.graphicsAnnot]{grDevices::as.graphicsAnnot()}}. A
list of length one can be provided, in which case its only element
is used as the label. If a list of longer length is provided, an item
named \code{'label'} must be provided (and will be used for the actual text).}

\item{n}{number of vertices for the \code{edges} and \code{fills}}

\item{...}{parameters to update \code{fills} and \code{edges} with and thereby a shortcut
to set these parameters}
}
\value{
Provides an object of class \code{'eulergram'} , which is a
description of the diagram to be drawn. \code{\link[=plot.eulergram]{plot.eulergram()}} does the actual
drawing of the diagram.
}
\description{
Plot diagrams fit with \code{\link[=euler]{euler()}} and \code{\link[=venn]{venn()}} using \code{\link[grid:Grid]{grid::Grid()}} graphics.
This
function sets up all the necessary plot parameters and computes
the geometry of the diagram. \code{\link[=plot.eulergram]{plot.eulergram()}}, meanwhile,
does the actual plotting of the diagram. Please see the \strong{Details} section
to learn about the individual settings for each argument.
}
\details{
The only difference between \code{\link[=plot.euler]{plot.euler()}} and \code{\link[=plot.venn]{plot.venn()}} is that
\code{quantities} is set to \code{TRUE} by default in the latter and \code{FALSE} in
the former.

Most of the arguments to this function accept either a logical, a vector, or
a list where
\itemize{
\item logical values set the attribute on or off,
\item vectors are shortcuts to commonly used options (see the individual
parameters), and
\item lists enable fine-grained control, including graphical
parameters as described in \code{\link[grid:gpar]{grid::gpar()}} and control
arguments that are specific to each argument.
}

The various \code{\link[grid:gpar]{grid::gpar()}} values that are available for each argument
are:

\tabular{lcccccccc}{
\tab fills \tab edges \tab labels \tab quantities \tab strips \tab legend \tab main \cr
col        \tab       \tab x     \tab x      \tab x          \tab x      \tab x      \tab x    \cr
fill       \tab x     \tab       \tab        \tab            \tab        \tab        \tab      \cr
alpha      \tab x     \tab x     \tab x      \tab x          \tab x      \tab x      \tab x    \cr
lty        \tab       \tab x     \tab        \tab            \tab        \tab        \tab      \cr
lwd        \tab       \tab x     \tab        \tab            \tab        \tab        \tab      \cr
lex        \tab       \tab x     \tab        \tab            \tab        \tab        \tab      \cr
fontsize   \tab       \tab       \tab x      \tab x          \tab x      \tab x      \tab x    \cr
cex        \tab       \tab       \tab x      \tab x          \tab x      \tab x      \tab x    \cr
fontfamily \tab       \tab       \tab x      \tab x          \tab x      \tab x      \tab x    \cr
lineheight \tab       \tab       \tab x      \tab x          \tab x      \tab x      \tab x    \cr
font       \tab       \tab       \tab x      \tab x          \tab x      \tab x      \tab x    \cr
}

Defaults for these values, as well as other parameters of the plots, can
be set globally using \code{\link[=eulerr_options]{eulerr_options()}}.

If the diagram has been fit using the \code{data.frame} or \code{matrix} methods
and using the \code{by} argument, the plot area will be split into panels for
each combination of the one to two factors.

For users who are looking to plot their diagram using another package,
all the necessary parameters can be collected if the result of this
function is assigned to a variable (rather than printed to screen).
}
\examples{
fit <- euler(c("A" = 10, "B" = 5, "A&B" = 3))

# Customize colors, remove borders, bump alpha, color labels white
plot(fit,
     fills = list(fill = c("red", "steelblue4"), alpha = 0.5),
     labels = list(col = "white", font = 4))

# Add quantities to the plot
plot(fit, quantities = TRUE)

# Add a custom legend and retain quantities
plot(fit, quantities = TRUE, legend = list(labels = c("foo", "bar")))

# Plot without fills and distinguish sets with border types instead
plot(fit, fill = "transparent", lty = 1:2)

# Save plot parameters to plot using some other method
diagram_description <- plot(fit)

# Plots using 'by' argument
plot(euler(fruits[, 1:4], by = list(sex)), legend = TRUE)
}
\seealso{
\code{\link[=euler]{euler()}}, \code{\link[=plot.eulergram]{plot.eulergram()}}, \code{\link[grid:gpar]{grid::gpar()}},
\code{\link[grid:grid.polyline]{grid::grid.polyline()}}, \code{\link[grid:grid.path]{grid::grid.path()}},
\code{\link[grid:grid.legend]{grid::grid.legend()}}, \code{\link[grid:grid.text]{grid::grid.text()}}
}
