% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.euler}
\alias{plot.euler}
\title{Plot euler diagrams}
\usage{
\method{plot}{euler}(x, fill = NULL, fill_opacity = 0.4, border = "black",
  lty = 1, lwd = 1, fontface = "plain", cex = 1, labels = NULL,
  key = FALSE, counts = FALSE, main = NULL, layout = NULL,
  outer_strips = TRUE, polygon_args, text_args, mar, ...)
}
\arguments{
\item{x}{euler diagram specification from \pkg{eulerr}}

\item{fill}{Colors to fill circles with.}

\item{fill_opacity}{Opacity of fill colors.}

\item{border}{Border color.}

\item{lty}{Line type(s) for circles. (See \code{\link[grid]{gpar}}.)}

\item{lwd}{Line weight(s) for circles. (See \code{\link[grid]{gpar}}.)}

\item{fontface}{Fontface. (See \code{\link[grid]{gpar}}.)}

\item{cex}{The relative size of text. (See \code{\link[grid]{gpar}}.)}

\item{labels}{Changes the labels from the original call.}

\item{key}{Set to \code{FALSE} to labels the sets, \code{TRUE}
to automatically generate a legend, or supply a list (please see the entry
for \code{auto.key} in \code{\link[lattice]{xyplot}}) to fine tune
the appreance of the legend.}

\item{counts}{Set to \code{TRUE} to label set combinations with counts from
the original data (not the fit).}

\item{main}{Plot title.}

\item{layout}{For euler grids, specifies the layout for the strip. Cannot be used
in conjunction with \code{outer_strips}, which will be automatically
set to false if \code{layout} is given.}

\item{outer_strips}{Whether to place the second level strips on the left of the
trellis plot. (Only applicable when there were 2 factors specifeid to
\code{by} in the call to \code{\link{euler}}.)}

\item{polygon_args}{Deprecated}

\item{text_args}{Deprecated}

\item{mar}{Deprecated}

\item{\dots}{Arguments to pass to \code{\link[lattice]{xyplot}}.}
}
\value{
Invisibly returns a trellis object, which can be updated or modified
  as usual.
}
\description{
Plot euler diagrams with trellis graphics from \pkg{lattice}. This function
calls \code{\link[lattice]{xyplot}} under the hood, allowing plots of
both individual euler diagrams as well as grids of diagrams
in case the \code{by} argument was used in the call to \code{\link{euler}}.
}
\details{
If \code{fill} is left blank, \pkg{eulerr} chooses color palettes based on
the number of sets and tries to provide palettes adapted to color vision
deficiencie based on functionality from \pkg{qualpalr}.

Several additional arguments can be handed down to
\code{\link[lattice]{xyplot}} via \ldots but be advised that this might cause
undesired conflicts with arguments that are provided inside this function.
It may be safer to use \code{\link[stats]{update}} to provide further
arguments instead.
}
\examples{
fit <- euler(c("A" = 10, "B" = 5, "A&B" = 3))
plot(fit, fill_opacity = 0.7)

# Change to italic roman font, remove borders and switch colors
plot(fit, fill = c("dodgerblue4", "darkgoldenrod1"), lwd = 0,
     fontface = "italic")

# Add counts to the plot
plot(fit, counts = TRUE)

# Add a custom legend and retain counts
plot(fit, counts = TRUE, key = list(space = "bottom", columns = 2))

# Plot without fills and distinguish sets with border types instead
plot(fit, lty = c("solid", "dotted"), fill = "transparent", cex = 2,
     fontface = 2, labels = c("foo", "bar"))

# Plot a grid of euler plots
dat <- data.frame(
  A      = sample(c(TRUE, FALSE), size = 100, replace = TRUE),
  B      = sample(c(TRUE, TRUE, FALSE), size = 100, replace = TRUE),
  gender = sample(c("Men", "Women"), size = 100, replace = TRUE),
  nation = sample(c("Sweden", "Denmark"), size = 100, replace = TRUE)
)

e_grid <- euler(dat[, 1:2], by = dat[, 3:4])
plot(e_grid, key = TRUE)

# We can modify the grid layout as well
plot(e_grid, layout = c(1, 4))

}
\seealso{
\code{\link[lattice]{xyplot}}, \code{\link[grid]{gpar}},
  \code{\link[grid]{grid.circle}}, \code{\link[lattice]{panel.xyplot}},
  \code{\link{euler}}, \code{\link[qualpalr]{qualpal}}
}
