% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ethno_boot.R
\name{ethno_boot}
\alias{ethno_boot}
\title{Bootstrap analyses of ethnobotany indices}
\usage{
ethno_boot(data, statistic, n1 = 1000, 
n2 = 1000 , use_weights = FALSE, weight_arg = NULL, ...)
}
\arguments{
\item{data}{Can be either a vector, matrix or a data.frame.}

\item{statistic}{A function that accepts data as its first argument and possibly the weights as its second, if use_weights is TRUE. Should return a numeric vector.}

\item{n1}{The size of the bootstrap sample.}

\item{n2}{The sample size used to calculate the statistic each bootstrap draw.}

\item{use_weights}{TRUE or FALSE about whether the statistic function accepts a weight argument or should be calculated using resampled data.}

\item{weight_arg}{If the statistic function includes a named argument for the weights this can be specified here.}

\item{...}{Further arguments passed on to the statistic function.}
}
\value{
Radial bar plot of chosen ethnobotany indices in ethnobotanyR package.
}
\description{
Creates a non-parametric bootstrap as a Bayesian Model \url{http://www.sumsar.net/blog/2015/04/the-non-parametric-bootstrap-as-a-bayesian-model/}. This is meant to be applied for ethnobotany data and indices in the ethnobotanyR package. Performs a Bayesian bootstrap and returns a sample of size 'n1' representing the posterior distribution of the chose statistic (i.e. 'mean'). The function returns a vector if the statistic is one-dimensional (like for mean(...)) or a data.frame if the statistic is multi-dimensional (like for the coefficients 'coefs.' of a regression model 'lm').
}
\section{Warning}{


Identification for informants and species must be listed by the names 'informant' and 'sp_name' respectively in the data set.
The rest of the columns should all represent separate identified ethnobotany use categories. These data should be populated with counts of uses per informant (should be 0 or 1 values).
}

\examples{

#Use built-in ethnobotany data example

ethno_boot(data = ethnobotanydata$Use_1, 
statistic = mean, n1 = 1000)

#Generate random dataset of three informants uses for four species

eb_data <- URs(ethnobotanydata)
 
ethno_boot(data = eb_data$URs, statistic = mean, 
n1 = 1000, n2 = 100)

}
\references{
Bååth, Rasmus. “The Non-Parametric Bootstrap as a Bayesian Model” Publishable Stuff, 2015. \url{http://www.sumsar.net/blog/2015/04/the-non-parametric-bootstrap-as-a-bayesian-model/}.
}
\keyword{Bayes}
\keyword{arith}
\keyword{graphs}
\keyword{logic}
\keyword{math}
\keyword{methods}
\keyword{misc}
\keyword{survey}
