% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_calcs.R
\name{pac}
\alias{pac}
\title{Compute the proportion above a specific cut location}
\usage{
pac(formula, data, cut, ref_group = NULL, diff = TRUE, tidy = TRUE)
}
\arguments{
\item{formula}{A formula of the type \code{out ~ group} where \code{out} is
the outcome variable and \code{group} is the grouping variable. Note this
variable can include any arbitrary number of groups.}

\item{data}{The data frame that the data in the formula come from.}

\item{cut}{The point(s) at the scale from which the proportion above should
be calculated from.}

\item{ref_group}{Optional. If the name of the reference group is provided
(must be character and match the grouping level exactly), only the
estimates corresponding to the given reference group will be returned.}

\item{diff}{Logical, defaults to \code{TRUE}. Should the difference between
the groups be returned? If \code{FALSE} the raw proportion above
the cut is returned for each group.}

\item{tidy}{Logical. Should the data be returned in a tidy data frame? (see
\href{https://www.jstatsoft.org/article/view/v059i10}{Wickham, 2014}). If
 false, effect sizes returned as a vector.}
}
\value{
Tidy data frame (or vector) of the proportion above the cutoff for 
each (or selected) groups.
}
\description{
This rather simple function  calls \link{cdfs}, to compute the
empirical cumulative distribution function for all levels of the grouping 
factor, and then calculates the proportion of the sample above any generic
point on the scale for all groups. Alternatively only specific proportions
can be returned.
}
\examples{
# Compute differences for all pairwise comparisons for each of three cuts
pac(reading ~ condition, 
		star, 
		cut = c(450, 500, 550)) 

# Report raw PAC, instead of differences in PAC
pac(reading ~ condition, 
		star, 
		cut = c(450, 500, 550), 
		diff = FALSE) 

# Report differences with regular-sized classrooms as the reference group
pac(reading ~ condition, 
		star, 
		cut = c(450, 500, 550), 
		ref_group = "reg") 

# Return a matrix instead of a data frame 
# (returns a vector if only one cut is provided)
pac(reading ~ condition, 
		star, 
		cut = c(450, 500, 550), 
		ref_group = "reg",
		tidy = FALSE) 
}
