% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binned_es_plot.R
\name{binned_plot}
\alias{binned_plot}
\title{Quantile-binned effect size plot}
\usage{
binned_plot(formula, data, ref_group = NULL, qtiles = seq(0, 1, 0.3333),
  se = TRUE, shade_col = NULL, shade_alpha = 0.3, annotate = FALSE,
  refline = TRUE, refline_col = "black", refline_lty = 2,
  refline_lwd = 2, rects = TRUE, rect_colors = c(rgb(0.2, 0.2, 0.2, 0.1),
  rgb(0.2, 0.2, 0.2, 0)), lines = TRUE, points = TRUE, legend = NULL,
  theme = NULL, ...)
}
\arguments{
\item{formula}{A formula of the type \code{out ~ group} where \code{out} is
the outcome variable and \code{group} is the grouping variable. Note the
grouping variable must only include only two groups.}

\item{data}{The data frame that the data in the formula come from.}

\item{ref_group}{Optional character vector (of length 1) naming the
reference group to be plotted on the x-axis. Defaults to the highest
scoring group.}

\item{qtiles}{The quantile bins to split the data by and calculate effect 
sizes. This argument is passed directly to \link{qtile_es}. 
Essentially, this is the binning argument. Defaults to \code{seq(0, 1, .33)}
which splits the distribution into thirds (lower, middle, upper). Any 
sequence is valid, but it is recommended the bins be even. For example
\code{seq(0, 1, .1)} would split the distributions into deciles.}

\item{se}{Logical. Should the standard errors around the effect size point
estimates be displayed? Defaults to \code{TRUE}, with the uncertainty 
displayed with shading.}

\item{shade_col}{Color of the standard error shading, if \code{se == TRUE}.
Defaults to the same color as the lines.}

\item{shade_alpha}{Transparency level of the standard error shading.
Defaults to 0.3.}

\item{annotate}{Logical. Defaults to \code{FALSE}. When \code{TRUE} and 
\code{legend == "side"} the plot is rendered such that additional
annotations can be made on the plot using low level base plotting functions
(e.g., \link[graphics]{arrows}). However, if set to \code{TRUE}, 
\link[grDevices]{dev.off} must be called before a new plot is rendered 
(i.e., close the current plotting window). Otherwise the plot will be
attempted to be rendered in the region designated for the legend). Argument
is ignored when \code{legend != "side"}.}

\item{refline}{Logical. Defaults to \code{TRUE}. Should a diagonal
reference line, representing the point of equal probabilities, be plotted?}

\item{refline_col}{Color of the reference line. Defaults to \code{"gray"}.}

\item{refline_lty}{Line type of the reference line. Defaults to \code{2}.}

\item{refline_lwd}{Line width of the reference line. Defaults to \code{2}.}

\item{rects}{Logical. Should semi-transparent rectangles be plotted in the 
background to show the binning? Defaults to \code{TRUE}.}

\item{rect_colors}{Color of rectangles to be plotted in the background, if
\code{rects == TRUE}. Defaults to alternating gray and transparent. 
Currently not alterable when \code{theme == "dark"}, in which case the rects
alternate a semi-transparent white and transparent.}

\item{lines}{Logical. Should the points between effect sizes across 
\code{qtiles} be connected via a line? Defaults to \code{TRUE}.}

\item{points}{Logical. Should points be plotted for each \code{qtiles} be 
plotted? Defaults to \code{TRUE}.}

\item{legend}{The type of legend to be displayed, with possible values 
\code{"base"}, \code{"side"}, or \code{"none"}. Defaults to \code{"side"}, 
when there are more than two groups and \code{"none"} when only comparing
two groups. If the option \code{"side"} is used the plot is split into two
plots, via \link[graphics]{layout}, with the legend displayed in the second 
plot. This scales better than the base legend (i.e., manually manipulating
the size of the plot after it is rendered), but is not compatible with 
multi-panel plotting (e.g., \code{par(mfrow = c(2, 2))} for a 2 by 2 plot).
When producing multi-panel plots, use \code{"none"} or \code{"base"}, the
latter of which produces the legend with the base \link[graphics]{legend}
function.}

\item{theme}{Visual properties of the plot. There are currently only two
themes implemented - a standard plot and a dark theme. If \code{NULL} 
(default), the theme will be produced with a standard white background. If
\code{"dark"}, a dark gray background will be used with white text and axes.}

\item{...}{Additional arguments passed to \link[graphics]{plot}. Note that
it is best to use the full argument rather than partial matching, given the
method used to call the plot. While some partial matching is supported 
(e.g., \code{m} for \code{main}, it is generally safest to supply the full
argument).}
}
\description{
Plots the effect size between two groups by matched (binned) quantiles 
(i.e., the results from \link{qtile_es}), with the matched
quantiles plotted along the x-axis and the effect size plotted along the 
y-axis. The intent is to examine how (if) the magnitude of the effect size
varies at different points of the distributions.
}
\examples{

# Default binned effect size plot
binned_plot(math ~ condition, star)

# Change the reference group to regular sized classrooms
binned_plot(math ~ condition, 
		star,
		ref_group = "reg")

# Change binning to deciles
binned_plot(math ~ condition, 
		star,
		ref_group = "reg",
		qtiles = seq(0, 1, .1))

# Suppress the standard error shading
binned_plot(math ~ condition, 
		star,
		se = FALSE)

# Change to dark theme
binned_plot(math ~ condition, 
		star,
		theme = "dark")
}
