% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_generics.R, R/02_Beta.R, R/02_Binom.R,
%   R/02_Dirichlet.R, R/02_Exp.R, R/02_Gammad.R, R/02_MGamma.R, R/02_Norm.R,
%   R/02_Pois.R
\name{ll}
\alias{ll}
\alias{ll,ANY,ANY,character-method}
\alias{llbeta}
\alias{ll,numeric,numeric,Beta-method}
\alias{llbinom}
\alias{ll,numeric,numeric,Binom-method}
\alias{lldirich}
\alias{ll,matrix,numeric,Dirichlet-method}
\alias{llexp}
\alias{ll,numeric,numeric,Exp-method}
\alias{llgamma}
\alias{ll,numeric,numeric,Gammad-method}
\alias{llmgamma}
\alias{ll,matrix,numeric,MGamma-method}
\alias{llnorm}
\alias{ll,numeric,numeric,Norm-method}
\alias{llpois}
\alias{ll,numeric,numeric,Pois-method}
\title{Log-Likelihood}
\usage{
ll(x, prm, distr, ...)

\S4method{ll}{ANY,ANY,character}(x, prm, distr, ...)

llbeta(x, shape1, shape2)

\S4method{ll}{numeric,numeric,Beta}(x, prm, distr)

llbinom(x, size, prob)

\S4method{ll}{numeric,numeric,Binom}(x, prm, distr)

lldirich(x, shape, mar = 2)

\S4method{ll}{matrix,numeric,Dirichlet}(x, prm, distr, mar = 2)

llexp(x, rate)

\S4method{ll}{numeric,numeric,Exp}(x, prm, distr)

llgamma(x, shape, scale)

\S4method{ll}{numeric,numeric,Gammad}(x, prm, distr)

llmgamma(x, shape, scale, mar = 2)

\S4method{ll}{matrix,numeric,MGamma}(x, prm, distr, mar = 2)

llnorm(x, mean, sd)

\S4method{ll}{numeric,numeric,Norm}(x, prm, distr)

llpois(x, lambda)

\S4method{ll}{numeric,numeric,Pois}(x, prm, distr)
}
\arguments{
\item{x}{numeric. A sample under estimation.}

\item{prm}{numeric. A vector of the distribution parameters.}

\item{distr}{A subclass of \code{Distribution}. The distribution family assumed.}

\item{...}{extra arguments.}

\item{shape1, shape2, size, prob, shape, rate, scale, mean, sd, lambda}{numeric.
Distribution parameters.}

\item{mar}{numeric. In univariate distributions, a matrix can be given
instead of a vector. In this case, the apply function is utilized and \code{mar}
is passed to the \code{MARGIN} argument. If each sample is a row, set \code{mar = 1},
if it is a column, set \code{mar = 2} (the default).}
}
\value{
Numeric. The value of the log-likelihood function.
}
\description{
These functions calculate the log-likelihood of an IID sample for specific
values of the distribution parameters. See Details.
}
\details{
The log-likelihood functions are provided in two forms: the \verb{ll<name>}
distribution-specific version that follows the base R conventions, and the
S4 generic \code{ll} that complements the \code{distr} package functionalities.
}
