% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh_in_new_ref.R
\name{mesh.in.new.ref}
\alias{mesh.in.new.ref}
\title{Change of frame of reference of a mesh}
\usage{
mesh.in.new.ref(
  mesh,
  new.ref.pseudo,
  T.MAT = NULL,
  alias = "",
  description = NULL
)
}
\arguments{
\item{mesh}{"volume" class object.}

\item{new.ref.pseudo}{pseudonym of the frame of reference in which the mesh
should be located. This \code{new.ref.pseudo} must exist in the \code{T.MAT} list.}

\item{T.MAT}{"t.mat" class object, created by \link[espadon]{load.patient.from.Rdcm},
\link[espadon]{load.patient.from.dicom}, \link[espadon]{load.T.MAT} or \link[espadon]{ref.add}.}

\item{alias}{Character string, \code{$alias} of the created object.}

\item{description}{Character string, describing the created object. If
\code{description = NULL} (default value), it will be that of the \code{mesh}.}
}
\value{
Returns "mesh" class object in the new frame of reference \code{new.ref.pseudo}.
}
\description{
The \code{mesh.in.new.ref} function allows you to change the frame
of reference of a mesh.
}
\examples{
# loading of toy-patient objects (decrease dxyz for better result)
step <- 4
patient <- toy.load.patient (modality = c("ct", "rtstruct", "mr"), 
                             roi.name = "", dxyz = rep (step, 3))
CT <- patient$ct[[1]]
S <- patient$rtstruct[[1]]

#creation of the patient mesh
bin <- bin.from.roi (CT, struct = S, roi.name = "patient")
mesh.patient <- mesh.from.bin (bin, alias = "patient", verbose = FALSE)

# mesh in the MR frame of reference
new.mesh <- mesh.in.new.ref (mesh.patient, patient$mr[[1]]$ref.pseudo, 
                             T.MAT = patient$T.MAT)

str (new.mesh, max.level = 2)                             
}
