% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_palette.R
\name{display.palette}
\alias{display.palette}
\title{Display of the color scale of a color palette}
\usage{
display.palette(
  col,
  breaks = NULL,
  factors = NULL,
  override.breaks = FALSE,
  bg = "black",
  new.window = TRUE,
  ylab = ""
)
}
\arguments{
\item{col}{Vector of colors like the ones generated by \code{rainbow},
\code{heat.colors}, etc.}

\item{breaks}{Vector of breaks for the color palette. It is the usual option
for images or dose, for instance. Its length must be one unit more than \code{col} length.}

\item{factors}{Vector containing the labels associated to each \code{col}. It should be used for
tissue identification or image segment labelling. Its length must be \code{col} length.}

\item{override.breaks}{Boolean. When \code{FALSE} (by default) ordinates are set to breaks. when \code{TRUE}
colors are uniformely displayed, and associated breaks set to the correct ordinates for the given colors.}

\item{bg}{Color of the background, seen by transparency for palette having alpha
channel.}

\item{new.window}{Boolean. If \code{TRUE}, it opens a new window for displaying
the palette.}

\item{ylab}{character string. Label of ordinates.}
}
\value{
Returns in a new device (if \code{new.window = TRUE}), or in the
active graphics window  (if \code{new.window = FALSE}), the palette color defined
by \code{col} and \code{breaks} in priority, or by \code{col} and \code{factors}.
}
\description{
The \code{Display.palette} function displays the color scale as it is used for representations
in espadon functions
}
\note{
the breaks are not necessarily evenly spaced. In this case, the colour palette
can be represented as the breaks are defined (default option) or by choosing a
constant spacing for each colour and displaying the associated abscissa
calculated from the breaks (override.breaks = TRUE).
}
\examples{
\dontrun{                
# simple example for breaks and factors

display.palette (c ("red", "green", "blue"), breaks = c(0, 1, 3, 7), 
                 ylab = "a simple color palette")
display.palette (c ("red", "green", "blue"), breaks = c(0, 1, 3, 7), 
                 override.breaks = TRUE)
display.palette (c ("red", "green", "blue"), factors = c ("red", "green", "blue"))
display.palette (c ("gray", "green", "blue"), factors = c (NA, 1, 2))

# for RVV palette, HU range must be [-1000, 1000]
display.palette (pal.RVV (255), breaks = seq (-1000, 1000, length.out=256))

# a palette for dose, for instance
display.palette (rainbow (255, start = 0, end = 4/6, rev = TRUE), 
                 breaks = seq (0, 60, length.out = 256))

# black & white palette for CTs or MRs
display.palette (grey.colors (255, start = 0, end = 1), 
                 breaks = seq (0, 60, length.out = 256))

# transparency affects colors depending on background (black in first exemple,
# white in the second one)
display.palette (rainbow (255, s = seq (1, 0, length.out = 255),
                          start = 0, end = 4/6,
                          alpha = seq (0.8, 0, length.out = 255), rev = TRUE),
                          breaks = seq (0, 60, length.out=256))
display.palette (rainbow (255, s = seq (1, 0, length.out = 255),
                          start = 0, end = 4/6,
                          alpha = seq (0.8, 0, length.out = 255), rev = TRUE),
                          breaks = seq (0, 60, length.out=256), bg = "white")
}                         
# colors contracted range using non uniform breaks in the plot window
display.palette (rainbow(255, s = seq(1, 0.8, length.out = 255), 
                         start = 0, end = 4/6, 
                         alpha = seq(0.8, 0.6, length.out = 255), rev = TRUE),
                 breaks = seq (0, 1, length.out = 256)^0.25 * 60, bg="grey", 
                 new.window = FALSE)

# the same using breaks override
display.palette (rainbow(255, s = seq(1, 0.8, length.out = 255), 
                         start = 0, end = 4/6, 
                         alpha = seq(0.8, 0.6, length.out = 255), rev = TRUE),
                 breaks = seq (0, 1, length.out = 256)^0.25 * 60, bg="grey", 
                 override.breaks = TRUE, new.window = FALSE)

}
