% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dicom_viewer.R
\name{dicom.viewer}
\alias{dicom.viewer}
\title{DICOM content viewer}
\usage{
dicom.viewer(
  dcm,
  txt.sep = "\\\\",
  txt.length = 100,
  tag.dictionary = dicom.tag.dictionary(),
  height = 600,
  width = 900,
  ...
)
}
\arguments{
\item{dcm}{espadon object of class "volume", "rtplan", "struct" provided by
DICOM files, or DICOM filename, or Rdcm filename, or raw vector  representing
the binary extraction of the DICOM file.}

\item{txt.sep}{String. Used if \code{as.txt = TRUE}. Separator of the tag value elements.}

\item{txt.length}{Positive integer. Used if \code{as.txt = TRUE}. Maximum number
of letters in the representation of the TAG value.}

\item{tag.dictionary}{Dataframe, by default equal to \link[espadon]{dicom.tag.dictionary},
whose structure it must keep. This dataframe is used to parse DICOM files.}

\item{height, width}{Height and width in pixel of the DICOM table.}

\item{...}{Additional argument \code{dicom.browser} when previously calculated by
\link[espadon]{dicom.browser}. Argument \code{nb} or \code{dicom.nb} representing the
number of DICOM file, when \code{dcm} contains multiple DICOM files.}
}
\value{
Returns the DICOM file description in a browser window.
}
\description{
the \code{dicom.viewer} function displays the data of a DICOM file.
}
\examples{
if (interactive ()) dicom.viewer (toy.dicom.raw ())
}
\seealso{
\link[espadon]{xlsx.from.dcm}, \link[espadon]{xlsx.from.Rdcm}, \link[espadon]{dicom.parser}
}
