% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relevantESVN.R
\name{relevantESVN}
\alias{relevantESVN}
\title{relevantESVN}
\usage{
relevantESVN(svyName = NULL, IMEI = NULL, STARTDATE = NULL,
  STARTTIME = NULL, ENDDATE = NULL, ENDTIME = NULL,
  START_DATETIME = NULL, END_DATETIME = NULL)
}
\arguments{
\item{svyName}{a vector of character string(s). The column name in (each of) the ESM dataset(s) that specifies the particular survey version.}

\item{IMEI}{a character string. Column name that specifies the variable in the respective dataset holding the the IMEI number.}

\item{STARTDATE}{a character string that specifies the column name in the respective dataset holding the date of when the participant started ... see \strong{Details}.}

\item{STARTTIME}{a character string that specifies the column name in the respective dataset holding the time of when the participant started ... see \strong{Details}.}

\item{ENDDATE}{a character string that specifies the column name in the respective dataset holding the date of when the participant ended ... see \strong{Details}.}

\item{ENDTIME}{a character string that specifies the column name in the respective dataset holding the time of when the participant ended ... see \strong{Details}.}

\item{START_DATETIME}{a character string. If \code{STARTDATE} and \code{STARTTIME} are not in two separate columns but are combined as a date-time object in a single column pass that column's name and ignore the arguments \code{STARTDATE} and \code{STARTTIME}.}

\item{END_DATETIME}{a character string. If \code{ENDDATE} and \code{ENDTIME} are not in two separate columns but are combined as a date-time object in a single column pass that column's name and ignore the arguments \code{ENDDATE} and \code{ENDTIME}.}
}
\value{
A list of the relevant variable/column names in the ESM dataset(s). To be used as the last argument in the function \code{\link{setES}}. The last element of the list is a logical value indicating whether the date and time are either separated (TRUE) or already a date-time object (FALSE). It is meaningful only for the subsequent function \code{\link{setES}}.
}
\description{
relevantESVN creates a list of the relevant variable names (VN) of (each of) the experience sampling (ES) dataset(s).
}
\details{
The relevant variable names (i.e. column names) must refer to the raw ESM dataset(s). The date and time of both start and end refers to the single ESM questionnaires, i.e. the date and time they actually were started on the phone and the date and time they were finished.
}
\examples{
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
# ------------------------------------------------------
# Run function 3 of 28; see esmprep functions' hierarchy.
# ------------------------------------------------------
# With date and time as separate arguments
relEs <- relevantESVN(svyName="survey_name", IMEI="IMEI",
STARTDATE="start_date", STARTTIME="start_time",
ENDDATE="end_date", ENDTIME="end_time")
# With date-time objects instead of separate date and time
relEs <- relevantESVN(svyName="survey_name", IMEI="IMEI",
START_DATETIME="start_dateTime", END_DATETIME="end_dateTime")
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
}
\seealso{
Exemplary code (fully executable) in the documentation of \code{\link{esmprep}} (function 3 of 28).
}
