% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ci.R
\name{check_CIbound}
\alias{check_CIbound}
\alias{invertTest}
\title{Confidence intervals for 'fLoss' estimators}
\usage{
check_CIbound(
  testBeta,
  obsEst,
  type = c("ridge", "lasso"),
  postParam,
  lambdaseq,
  X,
  nPost,
  ind = 1,
  Bstar = 100,
  B = 500,
  loss = "fMBV",
  lowerBound = TRUE,
  reproducible = TRUE,
  alpha = 0.025,
  returnDist = FALSE,
  ...
)

invertTest(
  interval,
  type = "ridge",
  lower.interval = interval,
  upper.interval = interval,
  ...,
  tol = 0.005,
  fulldetail = FALSE
)
}
\arguments{
\item{testBeta}{Candidate value of beta to test.}

\item{obsEst}{Estimate of beta from the observed data for which a confidence interval is desired}

\item{type}{String indicating "ridge" or "LASSO".}

\item{postParam}{List of parameters for the posterior distribution of beta. See \code{\link{samplePosterior}} for expected names.}

\item{lambdaseq}{Sequence of penalty values}

\item{X}{deisgn matrix}

\item{nPost}{Number of posterior samples to use.}

\item{ind}{Index of parameter to test. Defaults to 1.}

\item{Bstar}{Number of estimators to compute for comparison distribution. Larger values improve the precision of the procedure but increase computational cost.}

\item{B}{Passed to \code{\link{festLASSO}}}

\item{loss}{Either \code{"fMBV"} or \code{"fMSE"}.}

\item{lowerBound}{Logical indicating that the test is for a lower bound}

\item{reproducible}{Should the simulated datasets be reproducible?}

\item{alpha}{Percentile of the distribution to compare against. See details.}

\item{returnDist}{If TRUE, then distribution of estimates generated is returned
instead of comparison against \code{alpha}}

\item{...}{In \code{invertTest}, these are passed to \code{check_CIbound}. In 
\code{check_CIbound}, these arguments are passed to \code{\link{samplePosterior}}.}

\item{interval}{Interval to check. Used for both upper and lower bound, if they are not provided}

\item{lower.interval, upper.interval}{Bounding intervals over which to check for lower and upper endpoints of CI}

\item{tol}{Passed to \code{\link{uniroot}}}

\item{fulldetail}{If TRUE, then output from \code{\link{uniroot}} is included.}
}
\description{
Compute confidence intervals by 'inverting the test' to determine if a given value should lie in the confidence region.
}
\details{
This function is used as part of an 'inverting the test' approach to generate confidence intervals for estimators from \code{\link{festRidge}}. \code{Bstar} datasets are generated from slices of the posterior distribution of the model parameters where beta (or other parameter indicated by \code{ind}) is fixed at the value \code{testBeta}. For each dataset, beta is estimated via \code{\link{festRidge}} or \code{\link{festLASSO}}, and the resulting distribution of estimators is compared against the estimate from the observed data (\code{obsEst}).

The values of \code{lambdaseq}, \code{X}, \code{nPost}, and \code{loss} are passed to \code{\link{festRidge}} or \code{\link{festLASSO}} and typically match the values that were used to compute \code{obsEst}.

The computational cost of this function is most affected by the values of
\code{nPost} and \code{Bstar}. Large values of the latter are important for 
adequately representing the distribution of parameter estimates. In some
settings, \code{nPost} can be reduced without substantially impacting
the results. However, each dataset is likely to be different.
}
\seealso{
\code{\link{festRidge}}
}
\author{
Joshua Keller
}
