% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{prob_tox_samples}
\alias{prob_tox_samples}
\title{Get samples of the probability of toxicity.}
\usage{
prob_tox_samples(selector, tall = FALSE, ...)
}
\arguments{
\item{selector}{Object of type \code{\link{selector}}}

\item{tall}{logical, if FALSE, a wide data-frame is returned with columns
pertaining to the doses and column names the dose indices.
If TRUE, a tall data-frame is returned with data for all doses stacked
vertically. In this mode, column names will include \code{dose} and
\code{prob_tox}.}

\item{...}{arguments passed to other methods}
}
\value{
data-frame like object
}
\description{
Get samples of the probability of toxicity. For instance, a Bayesian approach
that supports sampling would be expected to return posterior samples of the
probability of toxicity. If this class does not support sampling, this
function will raise an error. You can check whether this class supports
sampling by calling \code{\link{supports_sampling}}.
}
\examples{
# CRM example
skeleton <- c(0.05, 0.1, 0.25, 0.4, 0.6)
target <- 0.25
outcomes <- '1NNN 2NTN'
fit <- get_dfcrm(skeleton = skeleton, target = target) \%>\% fit(outcomes)
fit \%>\% prob_tox_samples()
fit \%>\% prob_tox_samples(tall = TRUE)
}
