% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot_esaBcv.R
\name{plot.esabcv}
\alias{plot.esabcv}
\title{Plot Bi-cross-validation(BCV) Errors}
\usage{
\method{plot}{esabcv}(x, start.r = 0, end.r = NA,
  xlab = "Number of Factors", ylab = "BCV MSE",
  main = "Bi-cross-validation Error", col.line = "BLUE", ...)
}
\arguments{
\item{x}{\code{esabcv} object, typically result of \code{\link{EsaBcv}}.}

\item{start.r}{the starting number of factors to display in the plot.}

\item{end.r}{the largest number of factors allowed to display in the plot.
Default is NA, which means to make \code{end.r} as \code{max.r}.}

\item{xlab}{title for the x axis.}

\item{ylab}{title for the y axis.}

\item{main}{title for the plot.}

\item{col.line}{the line color.}

\item{...}{other parameters to be passed through to plotting functions.}
}
\value{
A plot ploting the average BCV entrywise MSE against the number of
factors tried (start.r to \code{max.r + 1}), with error bars (one standard deviation)
in grey and selected number of factors marked by a red crossing.
}
\description{
Plot the average BCV entrywise MSE against the number of factors tried,
with error bars and the best number of factors picked.
}
\details{
The \code{esabcv} object contains the raw BCV result \code{result.list},
which is a matrix with dimension \code{c(nRepeat, (max.r + 1))} where \code{nRepeat}
is the number of BCV repeats and \code{max.r} is the maximum number of factors tried.
If either tail of the error curve dominates, then the user has the option to change the start
and end rank for plotting.
}
\examples{
\dontrun{
data(simdat)
result <- EsaBcv(simdat$Y)
plot(result)
plot(result, start.r = 1)

}
}

