% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace-errors.R
\docType{methods}
\name{replace_errors}
\alias{replace_errors}
\alias{replace_errors,data.frame,validator-method}
\alias{replace_errors,data.frame,ErrorLocalizer-method}
\alias{replace_errors,data.frame,errorlocation-method}
\title{Replace erroneous fields with NA or a suggested value}
\usage{
replace_errors(data, x, ref = NULL, ..., value = c("NA", "suggestion"))

\S4method{replace_errors}{data.frame,validator}(data, x, ref = NULL, ...,
  value = c("NA", "suggestion"))

\S4method{replace_errors}{data.frame,ErrorLocalizer}(data, x, ref = NULL, ...,
  value = c("NA", "suggestion"))

\S4method{replace_errors}{data.frame,errorlocation}(data, x, ref = NULL, ...,
  value = c("NA", "suggestion"))
}
\arguments{
\item{data}{data to be checked}

\item{x}{\code{\link{validator}} object}

\item{ref}{optional reference data set}

\item{...}{these parameters are handed over to \code{\link{locate_errors}}}

\item{value}{\code{NA}}
}
\value{
\code{data} with erronuous values removed.
}
\description{
Find erronous fields using \code{\link{locate_errors}} and replace these
fields automatically with NA or a suggestion that is provided by the error detection algorithm.
}
\note{
In general it is better to replace the erronuous fields with \code{NA} and apply a proper
imputation methods. Suggested values from the error localization method may introduce an unwanted bias.

The errors that were removed from the \code{data.frame} can be retrieved with the function
 \code{\link{errors_removed}}. For more control over error localization see \code{\link{locate_errors}}.
}
\examples{
library(magrittr)

rules <- validator( profit + cost == turnover
              , cost - 0.6*turnover >= 0
              , cost>= 0
              , turnover >= 0
)
data <- data.frame(profit=755, cost=125, turnover=200)

data_no_error <-
  data \%>\%
  replace_errors(rules)

# faulty data was replaced with NA
data_no_error

errors_removed(data_no_error)

# a bit more control
error_locations <- locate_errors(data, rules)
data \%>\%
  replace_errors(error_locations)
}
\seealso{
\code{\link{errorlocation-class}}
}
