% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_intervals.R
\name{measure}
\alias{as.measure}
\alias{is.measure}
\alias{measure}
\title{Measures}
\usage{
measure(s, acc, f = function(x, y) {     abs(x - y) })

as.measure(x)

is.measure(x)
}
\arguments{
\item{s}{confidence level, e,g. s=0.05 for the standard 95 percent confidence interval.}

\item{acc}{accuracy achieved by error intervals.}

\item{f}{function used to compute error of intervals. See also 'Details'.}

\item{x}{an R object.}
}
\value{
\code{measure} returns an object of class \code{c("measure","list")}
with information regarding the error of a set of intervals.

\code{as.measure} returns an object of class
\code{c("measure",class(x))} with information contained in x if possible.
Returns x otherwise.

\code{is.measure} returns TRUE if x is an R object with
\code{"measure"} as one of its classes. FALSE otherwise.
}
\description{
\code{measure} creates an object of class
 \code{c("measure", "list")}.

\code{as.measure} attempts to coerce its argument \code{x} into an
object of class \code{c("measure", class(x))}. If this is not possible
\code{x} is returned unchanged.

\code{is.measure} returns TRUE if x is an R object with
\code{"measure"} as one of its classes. It returns FALSE otherwise.
}
\examples{
measure(0.1,0.7)

measure(0.1,0.7,function(x,y){y-x})


l<-list(s=0.1,acc=0.78,f=function(x,y){abs(x-y)},err=0.02)
as.measure(l)

v<-c("a","b")
as.measure(v)


l<-list(s=0.1,acc=0.78,f=function(x,y){abs(x-y)},err=0.02)
is.measure(l)
res<-as.measure(l)
is.measure(res)
}
\author{
Jesus Prada, \email{jesus.prada@estudiante.uam.es}
}
\references{
Link to the scientific paper

Prada, Jesus, and Jose Ramon Dorronsoro. "SVRs and Uncertainty Estimates in Wind 
Energy Prediction." Advances in Computational Intelligence. Springer International 
Publishing, 2015. 564-577,

with theoretical background for this package is provided below.

\url{http://link.springer.com/chapter/10.1007/978-3-319-19222-2_47}
}

