% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth.R
\name{smooth_ww}
\alias{smooth_ww}
\title{Smooth wastewater data (using pre-processed wastewater)}
\usage{
smooth_ww(ww.conc, prm.smooth, silent = FALSE)
}
\arguments{
\item{ww.conc}{Data frame. Must have variables:
\itemize{
\item \code{date}: calendar date of wastewater collection
\item \code{value}: pathogen concentration
}}

\item{prm.smooth}{List. list of smoothing parameters. Parameters should be
specified as followed:
\itemize{
\item \code{method}: smoothing method, either \code{'rollmean'} (rolling mean) or \code{'loess'} (LOESS smoothing via \code{\link[stats:loess]{stats::loess()}})
\item \code{window}: for \verb{method = 'rollmean} only; width of smoothing window in days
\item \code{align}: for \verb{method = 'rollmean} only; smoothing alignment, either \code{'center'}, \code{'left'}, \code{'right'}
\item \code{span}: for \code{method = 'loess'} only; smoothing span (see the documentation for \code{\link[stats:loess]{stats::loess()}} for details)
\item \code{floor}: optional call for wastewater concentration smoothing with \code{method = 'loess'} only; user defined minimum smoothing concentration
}
Set this entire list to \code{NULL} to turn off smoothing}

\item{silent}{Logical. Flag to suppress all output messages, warnings, and progress bars.}
}
\value{
Data frame
}
\description{
Smooth wastewater data (using pre-processed wastewater)
}
\keyword{internal}
