% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deconvolution_RL.R
\name{deconvolution_RL}
\alias{deconvolution_RL}
\title{Richardson-Lucy Deconvolution.}
\usage{
deconvolution_RL(
  observed,
  times,
  p_delay,
  max_iter = 50,
  out_col_name = "RL_result",
  right_censor = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{observed}{A vector of the number of observed cases, deaths,
hospitalizations, etc. per day}

\item{times}{A numeric vector of times corresponding to the entries in
observed. Must be the same length as observed.}

\item{p_delay}{A numeric vector whose entries give the probability that
the delay from infection to observation is exactly 0, 1, ... N days.
p_delay must sum to 1 and to  facilitate vectorization should be
the same length as observed, and times
(the last several entries will most likely be 0s).}

\item{max_iter}{Maximum number of times to iterate.
Following Goldstein et al., the algorithm continues to run until
the normalized chi2 statistic comparing the observed and expected number
of deaths per day falls below 1, or until the maximum number of
iterations is reached.}

\item{out_col_name}{String giving the name of the column
in which to output the imputed times of infection}

\item{right_censor}{If \code{TRUE} (default), upscale the observations
at the end of the time series based on the cumulative probability
that an infection occurring on that date would have been observed.}

\item{verbose}{Logical. Verbose mode.}
}
\value{
A data frame with columns time and out_col_name
(which gives the imputed number of infections per timestep)
}
\description{
Richardson-Lucy Deconvolution.
}
\keyword{internal}
