% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_R_cl_rep.R
\name{estimate_R_cl_rep}
\alias{estimate_R_cl_rep}
\title{Ensemble estimate of Rt}
\usage{
estimate_R_cl_rep(
  cl.daily,
  dist.repfrac,
  dist.repdelay,
  dist.incub,
  dist.gi,
  prm.R,
  silent = FALSE,
  RL.max.iter = 10
)
}
\arguments{
\item{cl.daily}{Dataframe of inferred daily incidence.}

\item{dist.repfrac}{List. Parameters for the reporting fraction distribution in the same format as returned by \code{\link[=def_dist_reporting_fraction]{def_dist_reporting_fraction()}}.}

\item{dist.repdelay}{List. Parameters for the reporting delay distribution in the same format as returned by \code{\link[=def_dist_reporting_delay]{def_dist_reporting_delay()}}.}

\item{dist.incub}{List. Parameters for the incubation period distribution in the same format as returned by \code{\link[=def_dist_incubation_period]{def_dist_incubation_period()}}.}

\item{dist.gi}{List. Parameters for the generation interval distribution in the same format as returned by \code{\link[=def_dist_generation_interval]{def_dist_generation_interval()}}.}

\item{prm.R}{List. Settings for the ensemble when calculating Rt.
Elements include:
\itemize{
\item \code{iter}: Integer. Number of iterations for the Rt ensemble
\item \code{CI}: Numeric between 0 and 1. Confidence interval width for Rt
estimates after sampling uncertain distributions.
\item \code{window}: Integer. Number of days defining the window of data used by
\code{EpiEstim} to estimate Rt. If \code{NULL}, will default to 7.
\item \code{config.EpiEstim}: (optional) configuration for \code{EpiEstim} defined via
\code{\link[EpiEstim:make_config]{EpiEstim::make_config()}}. If \code{NULL}, will use default config from
\code{EpiEstim}.
}}

\item{silent}{Logical. Flag to suppress all output messages, warnings, and progress bars.}

\item{RL.max.iter}{Integer. Maximum of iterations for the Richardson-Lucy deconvolution algorithm.}
}
\value{
A summary of individual Rt realizations with 95\% confidence intervals
}
\description{
Ensemble estimate of Rt
}
\seealso{
\code{\link[EpiEstim:make_config]{EpiEstim::make_config()}}
}
\keyword{internal}
