% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.ergmito}
\alias{predict.ergmito}
\title{Prediction method for \code{ergmito} objects}
\usage{
\method{predict}{ergmito}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{An object of class \link{ergmito}.}

\item{newdata}{New set of networks (or network) on which to make the prediction.}

\item{...}{Passed to \link{new_rergmito}, the workhorse of this method.}
}
\value{
A list of adjacency matrix of length \code{nnets(object)} or, if
specified \code{nnets(newdata)}.
}
\description{
Takes an \link{ergmito} object and makes prediction at tie level. See details for
information regarding its implementation.
}
\details{
After fitting a model with a small network (or a set of them), we
can use the parameter estimates to calculate the likelihood of observing any
given tie in the network, this is, the marginal probabilites at the tie level.

In particular, the function takes the full set of networks on the support of
the model and adds them up weighted by the probability of observing them as
predicted by the ERGM, formally:

\deqn{%
\hat{A} = \sum_i \mathbf{Pr}(A = a_i)\times a_i
}{%
\hat A = \sum_i Pr(A = a[i]) x a[i]
}

Where \eqn{\hat{A}}{\hat A} is the predicted adjacency matrix, and
\eqn{a_i}{a[i]} is the i-th network in the support of the model. This calculation
is done for each individual network used in the model.
}
\examples{
data(fivenets)

# bernoulli graph
fit <- ergmito(fivenets ~ edges) 

# all ties have the same likelihood
# which is roughly equal to:
# mean(nedges(fivenets)/(nvertex(fivenets)*(nvertex(fivenets) - 1)))
predict(fit) 


# If we take into account vertex attributes, now the story is different!
fit <- ergmito(fivenets ~ edges + nodematch("female")) 

# Not all ties have the same likelihood, since it depends on homophily!
predict(fit) 
}
