% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm_response.R
\name{ergm_preprocess_response}
\alias{ergm_preprocess_response}
\title{Update the network and the response argument.}
\usage{
ergm_preprocess_response(nw, response)
}
\arguments{
\item{nw}{a \code{\link[network:network]{network}} object.}

\item{response}{Either a character string, a formula, or \code{NULL} (the default), to specify the response attributes and whether the ERGM is binary or valued. Interpreted as follows: \describe{

\item{\code{NULL}}{Model simple presence or absence, via a binary ERGM.}

\item{character string}{The name of the edge attribute whose value is to be modeled. Type of ERGM will be determined by whether the attribute is \code{\link{logical}} (\code{TRUE}/\code{FALSE}) for binary or \code{\link{numeric}} for valued.}

\item{a formula}{must be of the form \code{NAME~EXPR|TYPE} (with \code{|} being literal). \code{EXPR} is evaluated in the formula's environment with the network's edge attributes accessible as variables. The optional \code{NAME} specifies the name of the edge attribute into which the results should be stored, with the default being a concise version of \code{EXPR}. Normally, the type of ERGM is determined by whether the result of evaluating \code{EXPR} is logical or numeric, but the optional \code{TYPE} can be used to override by specifying a scalar of the type involved (e.g., \code{TRUE} for binary and \code{1} for valued).}

}}
}
\description{
Update the network and the response argument.
}
\details{
\enumerate{
\item If \code{response} is \code{NULL} or \code{logical}, drop all edge attributes except for \code{na} and return the network and the response as they are.
\item If \code{response} is a character vector of length 1, drop all edge attributes in \code{nw} except for the one corresponding to \code{response}.
\item If \code{response} is a formula, construct a name for it and assign to that name (as an edge attribute) the result of evaluating the formula environment; drop all other edge attributes. Return as response the name (possibly with the attribute for the formula attached). If the formula's RHS is of the form a|b use the logicalness of b in Step 4.
\item Test if the resulting edge attribute is of mode \code{\link{logical}}. If so set \code{attr(response,'valued')} to \code{FALSE}, otherwise to \code{TRUE}.
}

If both \code{nw} and \code{response} are ordinary variables (i.e., not expressions) in the parent frame, \code{nw} (whatever it was named) is overwritten with the updated network and \code{response} (again, whatever it was named) is deleted. This is for convenience and for making outdated code that relies on \code{response} fail immediately rather than introduce subtle bugs. Otherwise, the updated network is returned.
}
\examples{

preproc_check_print <- function(nw, response){
  ergm_preprocess_response(nw, response) 
  str(list(
       valued = is.valued(nw),
       el = head(as.edgelist(nw, attrname=nw\%ergmlhs\%"response", output="tibble"),3)
  ))
}

data(florentine)
preproc_check_print(flomarriage, NULL)

flomarriage \%e\% "w" <- runif(network.edgecount(flomarriage))
flomarriage \%e\% "s" <- rep(c(-1,1), length.out=network.edgecount(flomarriage))

# Edge attribute expression
preproc_check_print(flomarriage, ~w*s)

# Named
preproc_check_print(flomarriage, wsprod~w*s)

# Binary from valued
preproc_check_print(flomarriage, ~s>0)

# Default edge attribute mode is valued
flomarriage[,] <- 0 # Empty network
preproc_check_print(flomarriage, ~w*s)

# Force default edge attribute mode to binary
preproc_check_print(flomarriage, ~w|TRUE)

}
\keyword{internal}
