% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{idegrange-ergmTerm}
\alias{idegrange-ergmTerm}
\alias{InitErgmTerm.idegrange}
\title{In-degree range}
\usage{
# binary: idegrange(from, to=+Inf, by=NULL, homophily=FALSE, levels=NULL)
}
\arguments{
\item{from, to}{vectors of distinct integers. If one of the vectors have length 1, it is recycled to the length of the other. Otherwise, it must have the same length.}

\item{by, homophily}{the optional argument \code{by} specifies a vertex attribute (see Specifying
Vertex attributes and Levels (\code{?nodal_attributes}) for details).
If this is specified and \code{homophily} is \code{TRUE} ,
then degrees are calculated using the subnetwork consisting of only
edges whose endpoints have the same value of the \code{by} attribute.
If \code{by} is specified and
\code{homophily} is \code{FALSE} (the default), then separate degree range
statistics are calculated for nodes having each separate
value of the attribute.}

\item{levels}{TODO (See Specifying Vertex
attributes and Levels (\code{\link[=nodal_attributes]{?nodal_attributes}}) for details.)}
}
\description{
This term adds one
network statistic to the model for each element of \code{from} (or \code{to} ); the \eqn{i} th
such statistic equals the number of nodes in the network of in-degree
greater than or equal to \code{from[i]} but strictly less than \code{to[i]} , i.e. with
in-edge count in semiopen interval \verb{[from,to)} .

This term can only be used with directed networks; for undirected
networks (bipartite and not)
see \code{degrange} . For degrees of specific modes of bipartite
networks, see \code{b1degrange} and \code{b2degrange} . For
in-degrees, see \code{idegrange} .
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.
}
\concept{categorical nodal attribute}
\concept{directed}
