% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.multinet.R
\name{as_tibble.combined_networks}
\alias{as_tibble.combined_networks}
\title{An \code{as_tibble} method for combined networks.}
\usage{
\method{as_tibble}{combined_networks}(
  x,
  attrnames = (match.arg(unit) \%in\% c("vertices", "networks")),
  ...,
  unit = c("edges", "vertices", "networks"),
  .NetworkID = ".NetworkID",
  .NetworkName = ".NetworkName"
)
}
\arguments{
\item{x}{a \code{\link{combined_networks}} (inheriting from \code{\link[network:network]{network::network}}).}

\item{attrnames}{a list (or a selection index) for attributes to obtain; for combined networks, defaults to all.}

\item{...}{additional arguments, currently passed to unlist()].}

\item{unit}{whether to obtain edge, vertex, or network attributes.}

\item{.NetworkID, .NetworkName}{Optional strings indicating the
vertex attributes used to distinguish and name the networks;
intended to be used by term developers.}
}
\description{
A method to obtain a network attribute table from a
\code{\link{combined_networks}} object, falling back to the
\code{\link[network:as.matrix.network]{network::as_tibble.network()}} if vertex or edge attributes are
required.
}
\seealso{
\code{\link[network:as.matrix.network]{network::as_tibble.network()}}
}
