% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Lazega}
\alias{Lazega}
\title{A network of advice, collaboration, and friendship in a law firm}
\format{
An object of class \code{network} of length 5.
}
\source{
This version of the dataset was retrieved from the \href{https://www.stats.ox.ac.uk/~snijders/siena/Lazega_lawyers_data.htm}{RSiena web site}
and was compiled by Christopher Steven Marcum and Pavel
N. Krivitsky for \insertCite{KrKo20e;textual}{ergm.multi}.
}
\usage{
data(Lazega)
}
\description{
This dataset contains a \code{\link{network}} of relations of various types
among 71 lawyers (partners and associates) in a New England
(Northeastern US) corporate law firm referred to as \dQuote{SG&R}
collected 1988--1991 by \insertCite{La01c;textual}{ergm.multi}.
}
\details{
All relations are directed.
}
\section{Nonstandard Vertex Attributes}{
 \describe{

\item{\code{age}}{(numeric) the lawyer's age.}

\item{\code{gender}}{(character) the lawyer's gender (\code{"man"}/\code{"woman"}).}

\item{\code{office}}{(character) in which of the firm's three offices the lawyer is based (\code{"Boston"}/\code{"Hartford"}/\code{"Providence"}).}

\item{\code{practice}}{(character) which area of law the lawyer practices (\code{"corporate"}/\code{"litigation"}).}

\item{\code{school}}{(character) from which law school the lawyer graduated (\code{"Harvard/Yale"}/\code{"UConnecticut"}/\code{"other"}).}

\item{\code{seniority}}{(numeric) the lawyer's seniority rank in the firm (1 = high).}

\item{\code{status}}{(character) the lawyer's status in the firm (\code{"associate"}/\code{"partner"}).}

\item{\code{yrs_frm}}{(numeric) the number of years the lawyer has been with the firm.}

}
}

\section{Nonstandard Edge Attributes}{
 Each directed edge
\eqn{i\rightarrow j}{i -> j} has the following attributes:
\describe{

\item{\code{advice}}{(logical) whether \eqn{i} has reported receiving advice from \eqn{j}. (Note that as defined, advice flows from head of the directed edge to the tail.)}

\item{\code{coworker}}{(logical) whether \eqn{i} has reported receiving \eqn{j}'s assistance in preparing documents. (Note that as defined, assistance flows from head of the directed edge to the tail.)}

\item{\code{friendship}}{(logical) whether \eqn{i} considers {j} a friend outside of work.}

}
}

\section{Licenses and Citation}{
 When publishing results obtained
using this data set, the original author
\insertCite{La01c}{ergm.multi} should be cited, along with this
\R package.
}

\examples{
\donttest{
data(Lazega)
# Construct a multilayer network for ergm(). (See `?Layer` for syntax.)
LLazega <- Layer(Lazega, c("advice", "coworker", "friendship"))
# Specify a layer logic model.
efit <- ergm(LLazega ~ L(~edges + mutual, ~advice) +
                       L(~edges + mutual, ~coworker) +
                       L(~edges + mutual, ~friendship) +
                       L(~edges + mutual, ~advice&coworker) +
                       L(~edges + mutual, ~advice&friendship) +
                       L(~edges + mutual, ~coworker&friendship))
summary(efit)
}
}
\references{
\insertAllCited{}
}
\keyword{datasets}
