% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d_devlin.R
\name{figure_3_3}
\alias{figure_3_3}
\title{Figure 3.3: EQ-5D values: smoothed lines and confidence intervals by groupvar}
\usage{
figure_3_3(
  df,
  names_eq5d = NULL,
  name_fu = NULL,
  levels_fu = NULL,
  name_groupvar,
  eq5d_version = NULL,
  country
)
}
\arguments{
\item{df}{Data frame with the EQ-5D, follow-up and grouping columns}

\item{names_eq5d}{Character vector of column names for the EQ-5D dimensions}

\item{name_fu}{Character string for the follow-up column}

\item{levels_fu}{Character vector containing the order of the values in the follow-up column. 
If NULL (default value), the levels will be ordered in the order of appearance in df.}

\item{name_groupvar}{Character string for the grouping column}

\item{eq5d_version}{Version of the EQ-5D instrument}

\item{country}{A character string representing the name of the country. 
This could be in a 2-letter format, full name or short name, as specified in the country_codes datasets.}
}
\value{
Summary plot and data used for plotting
}
\description{
Figure 3.3: EQ-5D values: smoothed lines and confidence intervals by groupvar
}
\examples{
tmp <- figure_3_3(df = example_data, name_fu = "month", 
  name_groupvar = "gender", country = "USA")
tmp$p
tmp$plot_data
}
