% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d-package.R
\docType{package}
\name{eq5d-package}
\alias{eq5d-package}
\alias{_PACKAGE}
\title{eq5d: Methods for Calculating 'EQ-5D' Utility Index Scores}
\description{
EQ-5D is a popular health related quality of life instrument used 
    in the clinical and economic evaluation of health care. Developed by the 
    EuroQol group <https://www.euroqol.org>, the instrument consists of two 
    components: health state description and evaluation. For the description 
    component a subject self-rates their health in terms of five dimensions; 
    mobility, self-care, usual activities, pain/discomfort, and 
    anxiety/depression using either a three-level (EQ-5D-3L,
    <https://www.euroqol.org/eq-5d-instruments/eq-5d-3l-about>) or a five-level
    (EQ-5D-5L, <https://www.euroqol.org/eq-5d-instruments/eq-5d-5l-about>) 
    scale. Frequently the scores on these five dimensions are converted to a 
    single utility index using country specific value sets, which can be used
    in the clinical and economic evaluation of health care as well as in 
    population health surveys. The eq5d package provides methods to calculate 
    index scores from a subject's dimension scores. 19 TTO and 9 VAS EQ-5D-3L value 
    sets including those for countries in Szende et al (2007) 
    <doi:10.1007/1-4020-5511-0> and Szende et al (2014) 
    <doi:10.1007/978-94-007-7596-1>, 15 EQ-5D-5L EQ-VT value sets from the EuroQol
    website, and the EQ-5D-5L crosswalk value sets developed by van Hout et al. (2012) 
    <doi:10.1016/j.jval.2012.02.008> are included. Additionally, a shiny web tool is 
    included to enable the calculation and visualisation of EQ-5D index values via a 
    web browser using EQ-5D dimension scores stored in CSV or Excel files.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/fragla/eq5d}
  \item Report bugs at \url{https://github.com/fragla/eq5d/issues}
}

}
\author{
\strong{Maintainer}: Fraser Morton \email{fraser.morton@glasgow.ac.uk}

Authors:
\itemize{
  \item Jagtar Singh Nijjar \email{jsn33@medschl.cam.ac.uk}
}

}
\keyword{internal}
