% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eqhsdi.R
\name{hsdi}
\alias{hsdi}
\title{Calculate the Health State Density Index}
\usage{
hsdi(scores, version, ignore.invalid = TRUE, digits = 2, ...)
}
\arguments{
\item{scores}{scores data.frame, numeric or character. For data.frame default column 
names should be MO, SC, UA, PD and AD representing Mobility, Self-care, 
Usual activities, Pain/discomfort and Anxiety/depression. Vector using five 
digit format can also be used.}

\item{version}{string of value "3L" or "5L" to indicate instrument version.}

\item{ignore.invalid}{booloean whether to ignore invalid scores. TRUE returns NA, FALSE throws an 
error.}

\item{digits}{numeric specifying the number of decimal places for percentages. Defaults to 1, 
use NULL to skip rounding.}

\item{...}{character vector, specifying "dimensions" column names. Defaults 
are "MO", "SC", "UA", "PD" and "AD".}
}
\value{
numeric containing the HSDI value.
}
\description{
Calculate the Health State Density Index (HSDI) for an EQ-5D dataset.
}
\examples{
dat <- read.csv(system.file("extdata", "eq5d3l_example.csv", package="eq5d"))
hsdi(dat, version="3L")

}
