% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ckd.R
\name{eGFR_child_SCysC}
\alias{eGFR_child_SCysC}
\alias{eGFR_child_SCysC.data.frame}
\alias{eGFR_child_SCysC.units}
\alias{eGFR_child_SCysC.numeric}
\title{eGFR Pediatric SCysC}
\usage{
eGFR_child_SCysC(...)

\method{eGFR_child_SCysC}{data.frame}(.data, SCysC, ...)

\method{eGFR_child_SCysC}{units}(SCysC, ...)

\method{eGFR_child_SCysC}{numeric}(SCysC, ...)
}
\arguments{
\item{...}{Further optional arguments}

\item{.data}{(data.frame) A data.frame, optional}

\item{SCysC}{Serum Cystatin C
column name, or vector of units or numeric if \code{.data} is not provided}
}
\value{
Estimated GFR
of the same type provided (numeric or units)
}
\description{
Using KDIGO 2012 Clinical Practice Guideline for
the Evaluation and Management of Chronic Kidney Disease
Volume 3 | Issue 1 | January 2013
}
\details{
See \url{https://kdigo.org/guidelines/ckd-evaluation-and-management/} for more details
}
\examples{
eGFR_child_SCysC(eGFR_pt_data,
  SCysC = "SCysC_"
)

eGFR_pt_data \%>\%
  dplyr::mutate(eGFR = eGFR_child_SCysC(
    SCysC = SCysC_
  ))
}
