% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql.R
\docType{class}
\name{EplusSql}
\alias{EplusSql}
\title{Retrieve Simulation Outputs Using EnergyPlus SQLite Output File}
\description{
\code{EplusSql} class wraps SQL queries that can retrieve simulation outputs using
EnergyPlus SQLite output file.
}
\details{
SQLite output is an optional output format for EnergyPlus. It will be
created if there is an object in class \code{Output:SQLite}. If the value of
field \code{Option} in class \code{Output:SQLite} is set to \code{"SimpleAndTabular"},
then database tables related to the tabular reports will be included.

There are more than 30 tables in the SQLite output file which contains all of
the data found in EnergyPlus's tabular output files, standard variable
and meter output files, plus a number of reports that are found in the
eplusout.eio output file. The full description for SQLite outputs is
described in the EnergyPlus \emph{"Output Details and Examples"}
documentation.

\code{EplusSql} class makes it possible to directly retrieve simulation results
without creating an \link{EplusJob} object which can only get simulation
outputs after the job was successfully run before.

However, it should be noted that, unlike \link{EplusJob}, there is no checking on
whether the simulation is terminated or completed unsuccessfully or, the
parent Idf has been changed since last simulation. This means that you
may encounter some problems when retrieve data from an unsuccessful
simulation. It is suggested to carefully go through the \code{.err} file to
make sure the output data in the SQLite is correct and reliable.
}
\section{Usage}{
\preformatted{epsql <- eplus_sql(sql)
epsql$path()
epsql$list_table()
epsql$read_table(table)
epsql$report_data(key_value = NULL, name = NULL, year = NULL, tz = "GMT", case = "auto", all = FALSE)
epsql$report_data_dict()
epsql$tabular_data()
epsql$print()
print(epsql)
}

\code{$path()} returns the path of EnergyPlus SQLite file.

\code{$report_data_dict()} returns a data.table which contains all information about
report data. For details on the meaning of each columns, please see
"2.20.2.1 ReportDataDictionary Table" in EnergyPlus "Output Details and
Examples" documentation.

\code{$report_data()} extracts the report data in a data.table using key values
and variable names.

\code{$tabular_data()} extracts all tabular data in a data.table.

\code{$print()} shows the core information of this EplusSql object, including the
path of the EnergyPlus SQLite file, last modified time of the SQLite file
and the path of the IDF file with the same name in the same folder.

\strong{Arguments}:
\itemize{
\item \code{epsql}: An \code{EplusSQL} object.
\item \code{sql}: A path to an local EnergyPlus SQLite output file.
\item \code{key_value}: A character vector to identify key name of the data. If
\code{NULL}, all keys of that variable will be returned. Default: \code{NULL}.
\item \code{name}: A character vector to specify the actual data name. If \code{NULL}, all
variables will be returned. Default: \code{NULL}.
\item \code{year}: The year of the date and time in column \code{DateTime}. If \code{NULL}, it
will be the current year. Default: \code{NULL}
\item \code{tz}: Time zone of date and time in column \code{DateTime}. Default: \code{"GMT"}.
\item \code{case}: If not \code{NULL}, a character column will be added indicates the case
of this simulation. If \code{"auto"}, the name of the SQL file will be used.
}
}

\examples{
\dontrun{
if (is_avail_eplus(8.8)) {
    idf_name <- "1ZoneUncontrolled.idf"
    epw_name <-  "USA_CA_San.Francisco.Intl.AP.724940_TMY3.epw"

    idf_path <- file.path(eplus_config(8.8)$dir, "ExampleFiles", idf_name)
    epw_path <- file.path(eplus_config(8.8)$dir, "WeatherData", epw_name)

    # copy to tempdir and run the model
    idf <- read_idf(idf_path)
    idf$run(epw_path, tempdir())

    # create from local file
    sql <- eplus_sql(file.path(tempdir(), "1ZoneUncontrolled.sql"))

    # get sql file path
    sql$path()

    # list all tables in the sql file
    sql$list_table()

    # read a specific table
    sql$read_table("Zones")

    # read report data dictionary
    sql$report_data_dict()

    # read report data
    sql$report_data(name = "EnergyTransfer:Building")

    # read tabular data
    sql$tabular_data()
}
}

}
\author{
Hongyuan Jia
}
